/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.support.web.service.impl;

import com.baijia.commons.lang.utils.file.FileUtils;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.support.web.dto.UploadResultDto;
import com.baijia.support.web.exception.UploadException;
import com.baijia.support.web.service.UploadService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadServiceImpl
implements UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadServiceImpl.class);
    private String uploadInterface;

    @Override
    public UploadResultDto upload(String id, byte[] data) {
        return this.upload(id, data, "");
    }

    @Override
    public UploadResultDto upload(String id, byte[] data, String ext) {
        MultipartFileWrapper wrapper = new MultipartFileWrapper("upfile", data, ext);
        ArrayList wrapperList = Lists.newArrayList();
        wrapperList.add(wrapper);
        return this.doUpload(id, wrapperList);
    }

    @Override
    public UploadResultDto upload(String id, List<MultipartFile> files) {
        try {
            ArrayList wrapperList = Lists.newArrayList();
            String fileNamePrefix = "upfile_";
            int i = 1;
            for (MultipartFile file : files) {
                String fileName = String.valueOf(fileNamePrefix) + i++;
                MultipartFileWrapper wrapper = new MultipartFileWrapper(fileName, file.getBytes(), this.getExt(file));
                wrapperList.add(wrapper);
            }
            return this.doUpload(id, wrapperList);
        }
        catch (IOException e) {
            throw new UploadException("getBytes exception - id:" + id, e);
        }
    }

    private UploadResultDto doUpload(String id, List<MultipartFileWrapper> wrapperList) {
        ArrayList localFiles = Lists.newArrayList();
        try {
            for (MultipartFileWrapper wrapper : wrapperList) {
                File localFile = this.saveToLocal(wrapper);
                wrapper.setLocalFile(localFile);
                localFiles.add(localFile);
            }
            String response = this.uploadToRemote(id, wrapperList);
            UploadResultDto uploadResultDto = this.parseResponse(response);
            return uploadResultDto;
        }
        finally {
            this.deleteTmpFiles(localFiles);
        }
    }

    private String uploadToRemote(String id, List<MultipartFileWrapper> wrapperList) {
        try {
            long start = System.currentTimeMillis();
            TreeMap fileParam = Maps.newTreeMap();
            for (MultipartFileWrapper wrapper : wrapperList) {
                fileParam.put(wrapper.getName(), wrapper.getLocalFile());
            }
            HashMap params = Maps.newHashMap();
            params.put("uid", id);
            logger.info("uploadUrl:{}, uid:{}, fileParam:{}", new Object[]{this.getUploadInterface(), id, fileParam});
            String response = HttpClientUtils.doPost((String)this.getUploadInterface(), (Map)params, (Map)fileParam);
            long end = System.currentTimeMillis();
            logger.debug("upload - id:{}, response:{}, cost:{}", new Object[]{id, response, end - start});
            return response;
        }
        catch (Exception e) {
            throw new UploadException("call remote upload service exception - ", e);
        }
    }

    private UploadResultDto parseResponse(String response) {
        try {
            logger.info("UploadServiceImpl.parseResponse: response:{}", (Object)response);
            Gson gson = new Gson();
            UploadResultDto dto = (UploadResultDto)gson.fromJson(response, UploadResultDto.class);
            List<UploadResultDto.UploadFile> uploadFiles = dto.getFiles();
            for (UploadResultDto.UploadFile uf : uploadFiles) {
                MultipartFileWrapper wrapper = MultipartFileWrapper.get(uf.getKey());
                uf.setExt(wrapper.getExt());
            }
            return dto;
        }
        catch (Exception e) {
            throw new UploadException("parse upload response exception - ", e);
        }
    }

    private File saveToLocal(MultipartFileWrapper wrapper) {
        try {
            String tmpFile = String.valueOf(this.getTmpDir()) + File.separator + this.getTmpFileName();
            if (!StringUtils.isBlank((CharSequence)wrapper.getExt())) {
                tmpFile = String.valueOf(tmpFile) + "." + wrapper.getExt();
            }
            FileUtils.write((String)tmpFile, (byte[])wrapper.getData());
            return new File(tmpFile);
        }
        catch (Exception e) {
            throw new UploadException("save local file exception - ", e);
        }
    }

    private String getExt(MultipartFile file) {
        return FileUtils.getLowercaseExt((String)file.getOriginalFilename());
    }

    private String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    private int getTmpFileName() {
        Random r = new Random();
        return Math.abs(r.nextInt());
    }

    private void deleteTmpFiles(List<File> files) {
        for (File file : files) {
            this.deleteTmpFile(file);
        }
    }

    private void deleteTmpFile(File file) {
        file.delete();
    }

    @Override
    public void setUploadInterface(String intf) {
        this.uploadInterface = intf;
    }

    @Override
    public String getUploadInterface() {
        return this.uploadInterface;
    }

    private static class MultipartFileWrapper {
        private static Map<String, MultipartFileWrapper> maps = Maps.newHashMap();
        private String name;
        private byte[] data;
        private String ext;
        private File localFile;

        MultipartFileWrapper(String name, byte[] data, String ext) {
            this.name = name;
            this.data = data;
            this.ext = ext;
            maps.put(name, this);
        }

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getExt() {
            return this.ext;
        }

        public File getLocalFile() {
            return this.localFile;
        }

        public void setLocalFile(File localFile) {
            this.localFile = localFile;
        }

        public static MultipartFileWrapper get(String name) {
            return maps.get(name);
        }
    }
}

