/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.support.web.dto;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PageDto
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2061383503526951091L;
    private static final int DEF_PAGE_SIZE = 20;
    private static final int DEF_PAGE_NUM = 1;
    private static final boolean DEF_IS_EMPTY_WHEN_OVERFLOW = false;
    private static final PageDto DEF_PAGE_DTO = new PageDto();
    private Integer count = 0;
    private Integer curPageCount = 0;
    private Integer pageNum = 1;
    private Integer pageSize = 20;
    private SortDto sort;
    private Integer maxPageSize = 100;
    private boolean isEmptyWhenOverflow = false;

    public static final PageDto getDefPageDto() {
        return DEF_PAGE_DTO.clone();
    }

    private Integer validateInt(Integer orig, Integer min, Integer def) {
        if (orig == null || orig < min) {
            return def;
        }
        return orig;
    }

    public void setCount(Integer count) {
        this.count = this.validateInt(count, 0, 0);
    }

    public void setCurPageCount(Integer curPageCount) {
        this.curPageCount = this.validateInt(curPageCount, 0, 0);
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = this.validateInt(pageNum, 1, 1);
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = this.validateInt(pageSize, 1, 20);
        if (this.pageSize > this.maxPageSize) {
            this.pageSize = this.maxPageSize;
        }
    }

    @Deprecated
    public Integer getOffset() {
        return this.firstNum();
    }

    public void validate() {
        if (this.count <= 0) {
            this.setPageNum(1);
            this.setCurPageCount(0);
            return;
        }
        int lastPageNum = (this.count - 1) / this.pageSize + 1;
        if (lastPageNum > this.pageNum) {
            this.setCurPageCount(this.pageSize);
            return;
        }
        int lastPageSize = (this.count - 1) % this.pageSize + 1;
        this.setCurPageCount(lastPageSize);
        if (lastPageNum < this.pageNum) {
            this.setPageNum(lastPageNum);
            if (this.isEmptyWhenOverflow) {
                this.setCurPageCount(0);
            }
            return;
        }
    }

    public int firstNum() {
        return (this.pageNum - 1) * this.pageSize;
    }

    public int lastNum() {
        return this.firstNum() + this.curPageCount;
    }

    public PageDto clone() {
        PageDto pageDto = new PageDto();
        pageDto.count = this.count;
        pageDto.pageNum = this.pageNum;
        pageDto.pageSize = this.pageSize;
        if (this.sort != null) {
            pageDto.sort = this.sort.clone();
        }
        return pageDto;
    }

    public static <T extends S, S> List<T> paging(List<T> list, PageDto pageDto) {
        return PageDto.paging(list, pageDto, null);
    }

    public static <T extends S, S> List<T> paging(List<T> list, PageDto pageDto, Comparator<S> defComparator) {
        if (pageDto == null) {
            if (defComparator != null) {
                Collections.sort(list, defComparator);
            }
            return list;
        }
        pageDto.setCount(list.size());
        pageDto.validate();
        SortDto sort = pageDto.getSort();
        if (sort != null && sort.getField() != null && sort.getOrder() != null) {
            BeanComparator comparator = new BeanComparator(sort.getField(), sort.getOrder());
            Collections.sort(list, comparator);
        } else if (defComparator != null) {
            Collections.sort(list, defComparator);
        }
        return list.subList(pageDto.firstNum(), pageDto.firstNum() + pageDto.getCurPageCount());
    }

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)5);
        PageDto pageDto = new PageDto();
        pageDto.setCount(56);
        pageDto.setCurPageCount(5);
        pageDto.setMaxPageSize(100);
        pageDto.setPageNum(1);
        pageDto.setPageSize(5);
        System.out.println(PageDto.paging(list, pageDto, null));
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getCurPageCount() {
        return this.curPageCount;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public SortDto getSort() {
        return this.sort;
    }

    public Integer getMaxPageSize() {
        return this.maxPageSize;
    }

    public boolean isEmptyWhenOverflow() {
        return this.isEmptyWhenOverflow;
    }

    public void setSort(SortDto sort) {
        this.sort = sort;
    }

    public void setMaxPageSize(Integer maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public void setEmptyWhenOverflow(boolean isEmptyWhenOverflow) {
        this.isEmptyWhenOverflow = isEmptyWhenOverflow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageDto)) {
            return false;
        }
        PageDto other = (PageDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Integer this$curPageCount = this.getCurPageCount();
        Integer other$curPageCount = other.getCurPageCount();
        if (this$curPageCount == null ? other$curPageCount != null : !((Object)this$curPageCount).equals(other$curPageCount)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        SortDto this$sort = this.getSort();
        SortDto other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        Integer this$maxPageSize = this.getMaxPageSize();
        Integer other$maxPageSize = other.getMaxPageSize();
        if (this$maxPageSize == null ? other$maxPageSize != null : !((Object)this$maxPageSize).equals(other$maxPageSize)) {
            return false;
        }
        return this.isEmptyWhenOverflow() == other.isEmptyWhenOverflow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Integer $curPageCount = this.getCurPageCount();
        result = result * 59 + ($curPageCount == null ? 43 : ((Object)$curPageCount).hashCode());
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        SortDto $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        Integer $maxPageSize = this.getMaxPageSize();
        result = result * 59 + ($maxPageSize == null ? 43 : ((Object)$maxPageSize).hashCode());
        result = result * 59 + (this.isEmptyWhenOverflow() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PageDto(count=" + this.getCount() + ", curPageCount=" + this.getCurPageCount() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", sort=" + this.getSort() + ", maxPageSize=" + this.getMaxPageSize() + ", isEmptyWhenOverflow=" + this.isEmptyWhenOverflow() + ")";
    }

    public static class BeanComparator<T>
    implements Comparator<T> {
        private String field;
        private String order;
        private String getMethodName;
        private Method getMethod;
        private static Converter<String, String> converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);

        public BeanComparator(String field, String order) {
            this.setField(field);
            this.setOrder(order);
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
            this.getMethodName = BeanComparator.getGetMethodNameByFieldName(field);
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public static String getGetMethodNameByFieldName(String field) {
            if (field == null || field.length() == 0) {
                return "get";
            }
            return "get" + (String)converter.convert((Object)field);
        }

        @Override
        public int compare(T o1, T o2) {
            if (this.order != null && this.order.equals("desc")) {
                return this.compareAsc(o2, o1);
            }
            return this.compareAsc(o1, o2);
        }

        private int compareAsc(T o1, T o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (this.getMethod == null) {
                this.initGetMethod(o1 == null ? o2 : o1);
            }
            Object v1 = null;
            Object v2 = null;
            try {
                v1 = this.getMethod.invoke(o1, new Object[0]);
                v2 = this.getMethod.invoke(o2, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            if (v1 == v2) {
                return 0;
            }
            if (v1 instanceof Comparable) {
                Comparable c1 = (Comparable)v1;
                Comparable c2 = (Comparable)v2;
                return c1.compareTo(c2);
            }
            return v1.toString().compareTo(v2.toString());
        }

        private void initGetMethod(T o) {
            Method[] methods;
            Class<?> clazz = o.getClass();
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(this.getMethodName)) {
                    this.getMethod = method;
                    return;
                }
                ++n2;
            }
        }
    }

    public static class SortDto
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 5039810022080659092L;
        private String field;
        private String order;

        protected SortDto clone() {
            SortDto sort = new SortDto();
            sort.field = this.field;
            sort.order = this.order;
            return sort;
        }

        public String getField() {
            return this.field;
        }

        public String getOrder() {
            return this.order;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortDto)) {
                return false;
            }
            SortDto other = (SortDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$order = this.getOrder();
            String other$order = other.getOrder();
            return !(this$order == null ? other$order != null : !this$order.equals(other$order));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SortDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : $order.hashCode());
            return result;
        }

        public String toString() {
            return "PageDto.SortDto(field=" + this.getField() + ", order=" + this.getOrder() + ")";
        }
    }
}

