/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.support.web.dao;

import com.baijia.commons.lang.utils.bean.BeanUtils;
import com.baijia.support.web.dto.PageDto;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.CollectionUtils;

public abstract class DaoTemplate<T> {
    private static final Logger log = LoggerFactory.getLogger(DaoTemplate.class);
    public static final SqlParameterSource[] EMPTY_PARAM_SOURCES = new SqlParameterSource[0];
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private Class<T> poClass;
    private String table;
    private Map<String, String> insertBeanFieldMap;
    private Set<String> insertIgnoreBeanFieldSet;
    private Map<String, String> updateBeanFieldMap;
    private Set<String> updateIgnoreBeanFieldSet;
    private Set<String> updateKeyBeanFieldSet;
    private Set<String> insertIgnoreTableFieldSet;
    private List<String> beanFields;
    private List<String> tableFields;
    private Map<String, String> tableFieldMapByBeanField;
    private String selectFromSql;
    private String querySql;
    private String listSql;
    private String countSql;
    private String insertSql;
    private String updateByIdSql;
    private String updateByKeySql;
    private String deleteByIdSql;
    private RowMapper<T> rowMapper;
    private ConcurrentMap<Class<?>, List<QueryUnit>> queryCache = Maps.newConcurrentMap();
    private static final SqlParameterSource BLANK_PARAM = new MapSqlParameterSource();

    public DaoTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate, String table) {
        this(namedParameterJdbcTemplate, table, null, null, null, null, null);
    }

    public DaoTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate, String table, Set<String> updateKeyBeanFieldSet) {
        this(namedParameterJdbcTemplate, table, null, null, null, null, updateKeyBeanFieldSet);
    }

    public DaoTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate, String table, Map<String, String> insertBeanFieldMap, Set<String> insertIgnoreBeanFieldSet, Map<String, String> updateBeanFieldMap, Set<String> updateIgnoreBeanFieldSet, Set<String> updateKeyBeanFieldSet) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.table = table;
        if (insertBeanFieldMap == null) {
            insertBeanFieldMap = Collections.emptyMap();
        }
        this.insertBeanFieldMap = insertBeanFieldMap;
        if (insertIgnoreBeanFieldSet == null) {
            insertIgnoreBeanFieldSet = Collections.singleton("id");
        }
        this.insertIgnoreBeanFieldSet = insertIgnoreBeanFieldSet;
        if (updateBeanFieldMap == null) {
            updateBeanFieldMap = Collections.emptyMap();
        }
        this.updateBeanFieldMap = updateBeanFieldMap;
        if (updateIgnoreBeanFieldSet == null) {
            updateIgnoreBeanFieldSet = Collections.singleton("id");
        }
        this.updateIgnoreBeanFieldSet = updateIgnoreBeanFieldSet;
        this.updateKeyBeanFieldSet = updateKeyBeanFieldSet;
        this.init();
    }

    private void init() {
        this.insertIgnoreTableFieldSet = this.insertIgnoreBeanFieldSet.stream().map(beanField -> BeanUtils.convertBeanField2TableField((String)beanField)).collect(Collectors.toSet());
        Joiner joiner = Joiner.on((String)",");
        this.poClass = BeanUtils.getActualTypeClass(this.getClass())[0];
        this.beanFields = BeanUtils.getBeanFieldsFromBean(this.poClass);
        this.tableFields = BeanUtils.getTableFieldsFromBeanFields(this.beanFields);
        this.tableFieldMapByBeanField = Maps.uniqueIndex(this.tableFields, BeanUtils::convertTableField2BeanField);
        this.selectFromSql = "select " + joiner.join(this.tableFields) + " from " + this.getTable();
        this.querySql = String.valueOf(this.selectFromSql) + " where true";
        this.listSql = String.valueOf(this.selectFromSql) + " where id in (:ids)";
        this.countSql = "select count(*) from " + this.getTable() + " where true";
        List insertFieds = this.beanFields.stream().filter(f -> !this.insertIgnoreBeanFieldSet.contains(f)).map(f -> {
            String replace = this.insertBeanFieldMap.get(f);
            if (replace == null) {
                return ":" + f;
            }
            return replace;
        }).collect(Collectors.toList());
        List insertTableFields = this.tableFields.stream().filter(field -> !this.insertIgnoreTableFieldSet.contains(field)).collect(Collectors.toList());
        this.insertSql = "insert into " + this.getTable() + "(" + joiner.join(insertTableFields) + ") values (" + joiner.join(insertFieds) + ")";
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(this.getTable()).append(" set ");
        List<String> updateFieldSql = this.getUpdateFieldEqualSqls(f -> !this.updateIgnoreBeanFieldSet.contains(f));
        this.updateByIdSql = "update " + this.getTable() + " set " + joiner.join(updateFieldSql) + " where id=:id";
        if (this.updateKeyBeanFieldSet == null) {
            this.updateByKeySql = this.updateByIdSql;
        } else {
            updateFieldSql = this.getUpdateFieldEqualSqls(f -> !this.updateIgnoreBeanFieldSet.contains(f) && !this.updateKeyBeanFieldSet.contains(f));
            List<String> updateKeyFieldSql = this.getUpdateFieldEqualSqls(this.updateKeyBeanFieldSet::contains);
            this.updateByKeySql = "update " + this.getTable() + " set " + joiner.join(updateFieldSql) + " where " + Joiner.on((String)" and ").join(updateKeyFieldSql);
        }
        this.deleteByIdSql = "delete from " + this.getTable() + " where id in (:ids)";
        this.rowMapper = new BeanPropertyRowMapper(this.poClass);
    }

    private List<String> getUpdateFieldEqualSqls(Predicate<String> filter) {
        return this.tableFieldMapByBeanField.entrySet().stream().filter(entry -> filter.test((String)entry.getKey())).map(this::getUpdateFieldEqualSql).collect(Collectors.toList());
    }

    private String getUpdateFieldEqualSql(Map.Entry<String, String> entry) {
        return String.valueOf(entry.getValue()) + "=" + this.updateBeanFieldMap.getOrDefault(entry.getKey(), ":" + entry.getKey());
    }

    public List<T> query(String sql, SqlParameterSource paramSource) {
        return this.namedParameterJdbcTemplate.query(sql, paramSource, this.rowMapper);
    }

    public <N extends Number> List<T> list(Collection<N> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        MapSqlParameterSource paramSource = new MapSqlParameterSource("ids", ids);
        return this.query(this.listSql, (SqlParameterSource)paramSource);
    }

    public List<T> listAll() {
        return this.query(this.selectFromSql, BLANK_PARAM);
    }

    public <N extends Number> T get(N id) {
        List<T> list = this.list(Collections.singletonList(id));
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public int[] update(Collection<T> list, String sql) {
        if (CollectionUtils.isEmpty(list)) {
            return new int[0];
        }
        return this.namedParameterJdbcTemplate.batchUpdate(sql, this.getBeanPropertySqlParameterSources(list));
    }

    private SqlParameterSource[] getBeanPropertySqlParameterSources(Collection<T> list) {
        List<SqlParameterSource> p = list.stream().map(BeanPropertySqlParameterSource::new).collect(Collectors.toList());
        return p.toArray(EMPTY_PARAM_SOURCES);
    }

    public int[] insert(Collection<T> list) {
        return this.update(list, this.insertSql);
    }

    public <N extends Number> int deleteById(Collection<N> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        return this.namedParameterJdbcTemplate.update(this.deleteByIdSql, (SqlParameterSource)new MapSqlParameterSource("ids", ids));
    }

    public int[] updateById(Collection<T> list) {
        return this.update(list, this.updateByIdSql);
    }

    public int[] updateByKey(Collection<T> list) {
        return this.update(list, this.updateByKeySql);
    }

    public <Q> StringBuilder procQuery(Q query) {
        return this.procQuery(query, null, null);
    }

    public <Q> StringBuilder procQuery(Q query, Map<String, QueryFormat> queryFormatMap) {
        return this.procQuery(query, null, queryFormatMap);
    }

    public <Q> StringBuilder procQuery(Q query, MapSqlParameterSource paramSource) {
        return this.procQuery(query, paramSource, null);
    }

    public <Q> StringBuilder procQuery(Q query, MapSqlParameterSource paramSource, Map<String, QueryFormat> queryFormatMap) {
        List<QueryUnit> queryUnits = this.getQueryField(query.getClass(), queryFormatMap);
        StringBuilder sql = new StringBuilder();
        queryUnits.forEach(q -> {
            try {
                String like;
                Object field = q.getGetter().invoke(query, new Object[0]);
                if (field == null) {
                    return;
                }
                if (q.getSqlFormat() == SqlFormat.LIKE && (like = field.toString()).endsWith("%")) {
                    field = String.valueOf(like) + "%";
                    Method setter = BeanUtils.getSetterFromBeanByField(query.getClass(), (String)q.getQueryField());
                    setter.invoke(query, field);
                }
                sql.append(String.format(q.getSqlFormat().getFormat(), q.getTableField(), q.getQueryField()));
                if (paramSource != null) {
                    paramSource.addValue(q.getQueryField(), field);
                }
            }
            catch (Exception e) {
                log.error("procQuery error, queryField:{}, exception:{}", q, (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
        });
        return sql;
    }

    private <Q> List<QueryUnit> parseQuery(Class<Q> clazz, Map<String, QueryFormat> queryFormatMap) {
        List getters = BeanUtils.getGetterFromBean(clazz);
        List queryFields = BeanUtils.getBeanFieldsFromGetter((List)getters);
        int size = getters.size();
        ArrayList queryUnits = Lists.newArrayListWithExpectedSize((int)size);
        queryFormatMap = (Map)MoreObjects.firstNonNull(queryFormatMap, Collections.emptyMap());
        int i = 0;
        while (i < size) {
            SqlFormat sqlFormat;
            String beanField;
            Method getter = (Method)getters.get(i);
            String queryField = (String)queryFields.get(i);
            QueryFormat queryFormat = (QueryFormat)queryFormatMap.get(queryField);
            if (queryFormat != null) {
                beanField = queryFormat.getBeanField();
                sqlFormat = queryFormat.getSqlFormat();
            } else {
                beanField = queryField;
                sqlFormat = BeanUtils.getAllSuperClass(getter.getReturnType()).contains(Collection.class) ? SqlFormat.IN : SqlFormat.EQUAL;
            }
            if (sqlFormat == SqlFormat.LIKE && !getter.getReturnType().equals(String.class)) {
                log.error("\u67e5\u8be2\u5b57\u6bb5{}\u4f7f\u7528like\u4f5c\u4e3a\u67e5\u8be2\u6761\u4ef6\uff0c\u503c\u7c7b\u578b\u5fc5\u987b\u4e3aString", (Object)queryField);
            } else {
                String tableField = this.tableFieldMapByBeanField.get(beanField);
                if (tableField == null) {
                    log.error("queryField:{}\u5bf9\u5e94\u7684beanField:{}\u5728Bean:{}\u4e2d\u4e0d\u5b58\u5728", new Object[]{queryField, beanField, this.poClass.getSimpleName()});
                } else {
                    queryUnits.add(QueryUnit.of(getter, queryField, tableField, sqlFormat));
                }
            }
            ++i;
        }
        return queryUnits;
    }

    private <Q> List<QueryUnit> getQueryField(Class<Q> clazz, Map<String, QueryFormat> queryFormatMap) {
        List<QueryUnit> queryFields = (List<QueryUnit>)this.queryCache.get(clazz);
        if (queryFields != null) {
            return queryFields;
        }
        queryFields = this.parseQuery(clazz, queryFormatMap);
        this.queryCache.put(clazz, queryFields);
        return queryFields;
    }

    public <Q> List<T> query(Q query, PageDto page) {
        return this.query(query, page, null);
    }

    public <Q> List<T> query(Q query, PageDto page, Map<String, QueryFormat> queryFormatMap) {
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        StringBuilder whereSql = this.procQuery(query, paramSource, queryFormatMap);
        StringBuilder sql = new StringBuilder(this.querySql);
        sql.append((CharSequence)whereSql);
        if (page != null) {
            String tableField;
            int count = (Integer)this.namedParameterJdbcTemplate.queryForObject(String.valueOf(this.countSql) + whereSql.toString(), (SqlParameterSource)paramSource, (rs, idx) -> rs.getInt(1));
            page.setCount(count);
            page.validate();
            if (page.getSort() != null && page.getSort().getField() != null && (tableField = this.tableFieldMapByBeanField.get(page.getSort().getField())) != null) {
                sql.append(" order by ").append(tableField);
                if (Objects.equals(page.getSort().getOrder(), "desc")) {
                    sql.append(" desc");
                } else {
                    sql.append(" asc");
                }
            }
            sql.append(" limit :start,:limit");
            paramSource.addValue("start", (Object)page.firstNum());
            paramSource.addValue("limit", (Object)page.getPageSize());
        }
        return this.query(sql.toString(), (SqlParameterSource)paramSource);
    }

    public String getTable() {
        return this.table;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public static class QueryFormat {
        @NonNull
        private String queryField;
        @NonNull
        private String beanField;
        @NonNull
        private SqlFormat sqlFormat;

        @NonNull
        public String getQueryField() {
            return this.queryField;
        }

        @NonNull
        public String getBeanField() {
            return this.beanField;
        }

        @NonNull
        public SqlFormat getSqlFormat() {
            return this.sqlFormat;
        }

        public void setQueryField(@NonNull String queryField) {
            if (queryField == null) {
                throw new NullPointerException("queryField");
            }
            this.queryField = queryField;
        }

        public void setBeanField(@NonNull String beanField) {
            if (beanField == null) {
                throw new NullPointerException("beanField");
            }
            this.beanField = beanField;
        }

        public void setSqlFormat(@NonNull SqlFormat sqlFormat) {
            if (sqlFormat == null) {
                throw new NullPointerException("sqlFormat");
            }
            this.sqlFormat = sqlFormat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryFormat)) {
                return false;
            }
            QueryFormat other = (QueryFormat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$queryField = this.getQueryField();
            String other$queryField = other.getQueryField();
            if (this$queryField == null ? other$queryField != null : !this$queryField.equals(other$queryField)) {
                return false;
            }
            String this$beanField = this.getBeanField();
            String other$beanField = other.getBeanField();
            if (this$beanField == null ? other$beanField != null : !this$beanField.equals(other$beanField)) {
                return false;
            }
            SqlFormat this$sqlFormat = this.getSqlFormat();
            SqlFormat other$sqlFormat = other.getSqlFormat();
            return !(this$sqlFormat == null ? other$sqlFormat != null : !((Object)((Object)this$sqlFormat)).equals((Object)other$sqlFormat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueryFormat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $queryField = this.getQueryField();
            result = result * 59 + ($queryField == null ? 43 : $queryField.hashCode());
            String $beanField = this.getBeanField();
            result = result * 59 + ($beanField == null ? 43 : $beanField.hashCode());
            SqlFormat $sqlFormat = this.getSqlFormat();
            result = result * 59 + ($sqlFormat == null ? 43 : ((Object)((Object)$sqlFormat)).hashCode());
            return result;
        }

        public String toString() {
            return "DaoTemplate.QueryFormat(queryField=" + this.getQueryField() + ", beanField=" + this.getBeanField() + ", sqlFormat=" + (Object)((Object)this.getSqlFormat()) + ")";
        }

        @ConstructorProperties(value={"queryField", "beanField", "sqlFormat"})
        private QueryFormat(@NonNull String queryField, @NonNull String beanField, @NonNull SqlFormat sqlFormat) {
            if (queryField == null) {
                throw new NullPointerException("queryField");
            }
            if (beanField == null) {
                throw new NullPointerException("beanField");
            }
            if (sqlFormat == null) {
                throw new NullPointerException("sqlFormat");
            }
            this.queryField = queryField;
            this.beanField = beanField;
            this.sqlFormat = sqlFormat;
        }

        public static QueryFormat of(@NonNull String queryField, @NonNull String beanField, @NonNull SqlFormat sqlFormat) {
            return new QueryFormat(queryField, beanField, sqlFormat);
        }
    }

    private static class QueryUnit {
        @NonNull
        private Method getter;
        @NonNull
        private String queryField;
        @NonNull
        private String tableField;
        @NonNull
        private SqlFormat sqlFormat;

        @NonNull
        public Method getGetter() {
            return this.getter;
        }

        @NonNull
        public String getQueryField() {
            return this.queryField;
        }

        @NonNull
        public String getTableField() {
            return this.tableField;
        }

        @NonNull
        public SqlFormat getSqlFormat() {
            return this.sqlFormat;
        }

        public void setGetter(@NonNull Method getter) {
            if (getter == null) {
                throw new NullPointerException("getter");
            }
            this.getter = getter;
        }

        public void setQueryField(@NonNull String queryField) {
            if (queryField == null) {
                throw new NullPointerException("queryField");
            }
            this.queryField = queryField;
        }

        public void setTableField(@NonNull String tableField) {
            if (tableField == null) {
                throw new NullPointerException("tableField");
            }
            this.tableField = tableField;
        }

        public void setSqlFormat(@NonNull SqlFormat sqlFormat) {
            if (sqlFormat == null) {
                throw new NullPointerException("sqlFormat");
            }
            this.sqlFormat = sqlFormat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryUnit)) {
                return false;
            }
            QueryUnit other = (QueryUnit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Method this$getter = this.getGetter();
            Method other$getter = other.getGetter();
            if (this$getter == null ? other$getter != null : !((Object)this$getter).equals(other$getter)) {
                return false;
            }
            String this$queryField = this.getQueryField();
            String other$queryField = other.getQueryField();
            if (this$queryField == null ? other$queryField != null : !this$queryField.equals(other$queryField)) {
                return false;
            }
            String this$tableField = this.getTableField();
            String other$tableField = other.getTableField();
            if (this$tableField == null ? other$tableField != null : !this$tableField.equals(other$tableField)) {
                return false;
            }
            SqlFormat this$sqlFormat = this.getSqlFormat();
            SqlFormat other$sqlFormat = other.getSqlFormat();
            return !(this$sqlFormat == null ? other$sqlFormat != null : !((Object)((Object)this$sqlFormat)).equals((Object)other$sqlFormat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueryUnit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : ((Object)$getter).hashCode());
            String $queryField = this.getQueryField();
            result = result * 59 + ($queryField == null ? 43 : $queryField.hashCode());
            String $tableField = this.getTableField();
            result = result * 59 + ($tableField == null ? 43 : $tableField.hashCode());
            SqlFormat $sqlFormat = this.getSqlFormat();
            result = result * 59 + ($sqlFormat == null ? 43 : ((Object)((Object)$sqlFormat)).hashCode());
            return result;
        }

        public String toString() {
            return "DaoTemplate.QueryUnit(getter=" + this.getGetter() + ", queryField=" + this.getQueryField() + ", tableField=" + this.getTableField() + ", sqlFormat=" + (Object)((Object)this.getSqlFormat()) + ")";
        }

        @ConstructorProperties(value={"getter", "queryField", "tableField", "sqlFormat"})
        private QueryUnit(@NonNull Method getter, @NonNull String queryField, @NonNull String tableField, @NonNull SqlFormat sqlFormat) {
            if (getter == null) {
                throw new NullPointerException("getter");
            }
            if (queryField == null) {
                throw new NullPointerException("queryField");
            }
            if (tableField == null) {
                throw new NullPointerException("tableField");
            }
            if (sqlFormat == null) {
                throw new NullPointerException("sqlFormat");
            }
            this.getter = getter;
            this.queryField = queryField;
            this.tableField = tableField;
            this.sqlFormat = sqlFormat;
        }

        public static QueryUnit of(@NonNull Method getter, @NonNull String queryField, @NonNull String tableField, @NonNull SqlFormat sqlFormat) {
            return new QueryUnit(getter, queryField, tableField, sqlFormat);
        }
    }

    public static enum SqlFormat {
        EQUAL(1, " and %s=:%s"),
        IN(2, " and %s in (:%s)"),
        LIKE(3, " and %s like :%s"),
        LT(4, " and %s<:%s"),
        GT(5, " and %s>:%s"),
        LE(6, " and %s<=:%s"),
        GE(7, " and %s>=:%s");

        private int id;
        private String format;

        private SqlFormat(int id, String format) {
            this.id = id;
            this.format = format;
        }

        public int getId() {
            return this.id;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

