<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <title>${title}</title>
    <link rel="stylesheet" href="http://cdn.bootcss.com/bootstrap/3.3.5/css/bootstrap.min.css"/>
</head>
<body>

<div class="container">
    <div class="row" style="margin-top: 20px; margin-bottom: 20px;">
        <div class="col-md-12">
        <#if deadList?has_content>
            死亡节点: [
            <#list deadList as dead>
                <#if dead?is_first>
                ${dead}
                <#else>
                ,${dead}
                </#if>
            </#list>
            ]
        <#else >
            [无死亡节点]
        </#if>
        <#if deltaDead?has_content  || deltaAlive?has_content>
            当前时间段
            <#if deltaDead?has_content>
                Alive -> Dead:
                <#list deltaDead as dead>
                ${dead}
                </#list>
            </#if>
            <#if deltaAlive?has_content>
                Dead -> Alive:
                <#list deltaAlive as alive>
                ${alive}
                </#list>
            </#if>
        </#if>
        </div>
        <div class="col-md-12">
            <table class="table">
                <thead>
                <tr>
                    <th>logicId</th>
                    <th>wechatUsername</th>
                    <th>machineInfo</th>
                    <th>ipv4</th>
                    <th>publicIpv4</th>
                    <th>Cluster</th>
                    <th>Status</th>
                    <th>Delta</th>
                </tr>
                </thead>
                <tbody>

                <#if reporterDatas??>
                    <#list reporterDatas as reportData>
                        <#if reportData.status == "Alive">
                            <tr class="success">
                        <#else>
                            <tr class="danger">
                        </#if>
                            <th>${reportData.logicId!"xxx"}</th>
                            <td>${reportData.wechatUsername!"xxx"}</td>
                            <td>${reportData.machineInfo!"xxx"}</td>
                            <td>${reportData.ipv4!"xxx"}</td>
                            <td>${reportData.publicIpv4!"xxx"}</td>
                            <td>${reportData.cluster!"xxx"}</td>
                            <td>${reportData.status!"xxx"}</td>
                            <td>${reportData.delta!""}</td>
                        </tr>
                    <#else>
                        <tr class="no-records-found">
                            <td colspan="8" class="text-center">No matching records found</td>
                        </tr>
                    </#list>
                </#if>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>