/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.listener;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.baijia.databus.AbstractProcessor;
import com.baijia.databus.ChangedRow;
import com.baijia.databus.utils.DatabusUtils;
import com.baijia.storm.lib.model.WeChatroom;
import com.baijia.storm.sun.api.common.model.QueueKey;
import com.baijia.storm.sun.dal.ad.mapper.StormSunDevicePoMapper;
import com.baijia.storm.sun.dal.ad.mapper.StormSunWeChatChatroomPoMapper;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.runner.Task.XRobotLeaveChatroomTask;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StormSunAllocationListener
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(StormSunAllocationListener.class);
    @Resource
    private XRobotLeaveChatroomTask leaveChatroomTask;
    @Resource
    private StormSunWeChatChatroomPoMapper chatroomPoMapper;
    @Resource
    private StormSunDevicePoMapper devicePoMapper;
    private Gson gson = new Gson();

    protected boolean process(List<ChangedRow> changedRows) {
        List chatrooms = changedRows.stream().filter(row -> CanalEntry.EventType.INSERT.equals((Object)row.getChangedType())).map(row -> DatabusUtils.getString((Map)row.getNewValue(), (String)"queue_key")).map(QueueKey::new).filter(QueueKey::isValid).filter(key -> "c".equals(key.getType())).map(QueueKey::getEntity).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(chatrooms)) {
            return true;
        }
        List<WeChatroom> weChatroomList = this.chatroomPoMapper.selectByChatroomList(chatrooms).stream().map(wechatroomPo -> (WeChatroom)this.gson.fromJson(wechatroomPo.getRawContent(), WeChatroom.class)).collect(Collectors.toList());
        Map<String, StormSunDevicePo> devicePoByName = this.devicePoMapper.selectBySpecialized(Byte.valueOf((byte)1)).stream().collect(Collectors.toMap(StormSunDevicePo::getWechatUsername, devicePo -> devicePo));
        try {
            this.leaveChatroomTask.leaveChatroom(weChatroomList, devicePoByName);
        }
        catch (Exception e) {
            log.error("Error while");
        }
        return true;
    }

    public String topic() {
        return "ad.storm_sun_allocation";
    }
}

