/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task.nursery;

import com.baijia.storm.sun.api.common.model.PrismRecord;
import com.baijia.storm.sun.dal.ad.mapper.PrismRecordPoMapper;
import com.baijia.storm.sun.dal.ad.mapper.StormSunDevicePoMapper;
import com.baijia.storm.sun.dal.po.PrismRecordPo;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.nursery.action.manager.NurseryManager;
import com.baijia.storm.sun.nursery.action.model.NurseryAction;
import com.baijia.storm.sun.nursery.action.model.impl.DailyUpdateDataActionImpl;
import com.baijia.storm.sun.nursery.action.model.impl.PrismRecordAction;
import com.baijia.storm.sun.nursery.util.NurseryActionFactory;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class NurseryDBMonitor
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(NurseryDBMonitor.class);
    @Resource
    private NurseryManager nurseryManager;
    @Resource
    private StormSunDevicePoMapper stormSunDevicePoMapper;
    @Resource
    private PrismRecordPoMapper prismRecordPoMapper;
    private static SimpleDateFormat dateComplexFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat dateSimpleFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final long INTERVAL = 120000L;
    private long lastPrismRecordId = -1L;
    private String beginTime = dateComplexFormat.format(new Date());
    private String systemStartDate = "1970-01-01";
    private boolean isLastUpdateRobotsSuccess = false;

    @Override
    @Scheduled(fixedDelay=120000L)
    public void run() throws Exception {
        if (this.isDateUpdated() || !this.isLastUpdateRobotsSuccess) {
            this.reloadAllRobots();
        }
        this.monitorPrism();
    }

    private boolean isDateUpdated() throws Exception {
        String curDate = dateSimpleFormat.format(new Date());
        if (curDate.compareTo(this.systemStartDate) != 0) {
            log.info("[NurseryDBMonitor] [data need update, system start date:{}, current date:{}]", (Object)this.systemStartDate, (Object)curDate);
            this.systemStartDate = curDate;
            this.nurseryManager.pushAction((NurseryAction)new DailyUpdateDataActionImpl(null));
            return true;
        }
        return false;
    }

    private void reloadAllRobots() {
        List allRobots = this.stormSunDevicePoMapper.selectByStatus(Byte.valueOf((byte)0));
        log.info("[NurseryDBMonitor] [reloadAllRobots] [reload {} robots, reload time:{}]", (Object)(allRobots == null ? 0 : allRobots.size()), (Object)dateComplexFormat.format(new Date()));
        this.isLastUpdateRobotsSuccess = this.nurseryManager.setAllRobots(allRobots);
    }

    private void monitorPrism() {
        List prismRecordPoList = this.prismRecordPoMapper.monitorPrism(this.lastPrismRecordId);
        if (prismRecordPoList != null) {
            int validRecordCount = 0;
            for (PrismRecordPo prismRecordPo : prismRecordPoList) {
                this.lastPrismRecordId = Math.max(prismRecordPo.getId(), this.lastPrismRecordId);
                try {
                    PrismRecord pr = (PrismRecord)new Gson().fromJson(prismRecordPo.getRawContent(), PrismRecord.class);
                    if (this.filterPrismRecord(pr)) continue;
                    this.nurseryManager.pushAction((NurseryAction)this.genPrismRecordAction(pr));
                    ++validRecordCount;
                }
                catch (Exception e) {
                    log.error("[NurseryDBMonitor] [monitorPrism] [process PrismRecord id:{} failed] [{}]", new Object[]{prismRecordPo.getId(), prismRecordPo.getRawContent(), e});
                }
            }
            log.info("[NurseryDBMonitor] [monitorPrism] [fetched {} PrismRecord, valid record count:{}  lastPrismRecordId:{}, systemBeginTime:{}]", new Object[]{prismRecordPoList.size(), validRecordCount, this.lastPrismRecordId, this.beginTime});
        }
    }

    private boolean filterPrismRecord(PrismRecord pr) {
        if (pr == null) {
            return true;
        }
        if (pr.getType() == null || pr.getType() != 100) {
            return true;
        }
        if (pr.getToUsernames() == null || pr.getToUsernames().isEmpty()) {
            return true;
        }
        if (pr.getToUsernames().size() != 1) {
            return true;
        }
        return pr.getWeChatMsgType() != 1;
    }

    private PrismRecordAction genPrismRecordAction(PrismRecord pr) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (!this.nurseryManager.getUserName2DevicePoMapper().containsKey(pr.getFromUsername()) || !this.nurseryManager.getUserName2DevicePoMapper().containsKey(pr.getToUsernames().get(0))) {
            return null;
        }
        if (((StormSunDevicePo)this.nurseryManager.getUserName2DevicePoMapper().get(pr.getFromUsername())).getLogicId().equals(pr.getLogicId())) {
            return null;
        }
        return (PrismRecordAction)NurseryActionFactory.newNurseryAction((String)pr.getFromUsername(), (String[])new String[]{(String)pr.getToUsernames().get(0)}, (String)pr.getContent(), PrismRecordAction.class);
    }
}

