/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task.nursery;

import com.baijia.storm.sun.api.common.model.PrismRecord;
import com.baijia.storm.sun.dal.ad.mapper.PrismRecordPoMapper;
import com.baijia.storm.sun.dal.po.PrismRecordPo;
import com.baijia.storm.sun.nursery.action.manager.NurseryManager;
import com.baijia.storm.sun.nursery.model.chat.ChatPool;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.google.gson.Gson;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class NurseryChatPoolMonitor
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(NurseryChatPoolMonitor.class);
    @Resource
    private ChatPool historyChatPool;
    @Resource
    private PrismRecordPoMapper prismRecordPoMapper;
    @Value(value="${filter_content}")
    private String filterContent;
    @Value(value="${filter_usernames}")
    private String filterUsernames;
    @Value(value="${filter_symbol}")
    private String filterSymbol;
    @Resource
    private NurseryManager nurseryManager;
    private long lastPrismRecordId = -1L;
    public static final long INTERVAL = 900000L;
    @Value(value="${chat_pool_fetch_limit_per_time}")
    private int fetchLimit;

    @Override
    @Scheduled(fixedDelay=900000L)
    public void run() throws Exception {
        this.monitorChatMessage();
    }

    private void monitorChatMessage() {
        List records = this.prismRecordPoMapper.monitorChatMessage(this.lastPrismRecordId, this.fetchLimit);
        if (records == null || records.isEmpty()) {
            log.info("[NurseryChatPoolMonitor] [monitorChatMessage] [fetched nothing, reset lastPrismRecordId -1]");
            this.lastPrismRecordId = -1L;
            return;
        }
        int validRecordCount = 0;
        for (PrismRecordPo prismRecordPo : records) {
            this.lastPrismRecordId = Math.max(prismRecordPo.getId(), this.lastPrismRecordId);
            try {
                PrismRecord pr = (PrismRecord)new Gson().fromJson(prismRecordPo.getRawContent(), PrismRecord.class);
                if (this.filterPrismRecord(pr)) continue;
                this.historyChatPool.putContent(pr.getContent());
                ++validRecordCount;
            }
            catch (Exception e) {
                log.error("[NurseryChatPoolMonitor] [monitorChatMessage] [process PrismRecord id:{} failed] [{}]", new Object[]{prismRecordPo.getId(), prismRecordPo.getRawContent(), e});
            }
        }
        log.info("[NurseryChatPoolMonitor] [monitorChatMessage] [fetched {} PrismRecord, valid record count:{}  lastPrismRecordId:{}]", new Object[]{records.size(), validRecordCount, this.lastPrismRecordId});
    }

    private boolean filterPrismRecord(PrismRecord pr) {
        if (pr == null) {
            return true;
        }
        if (pr.getWeChatMsgType() != 1) {
            return true;
        }
        if (pr.getContent() == null) {
            return true;
        }
        if (pr.getContent().trim().isEmpty()) {
            return true;
        }
        if (pr.getFromUsername() == null) {
            return true;
        }
        if (this.filterUsernames.contains(pr.getFromUsername())) {
            return true;
        }
        if (pr.getContent().contains(this.filterSymbol)) {
            return true;
        }
        return this.filterContent.contains(pr.getContent().toLowerCase());
    }
}

