/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task;

import com.baijia.storm.lib.model.WeChatroom;
import com.baijia.storm.sun.api.common.constant.ChatroomStatus;
import com.baijia.storm.sun.api.common.exception.CustomException;
import com.baijia.storm.sun.api.common.model.SunTask;
import com.baijia.storm.sun.api.common.util.QueueKeyGenerator;
import com.baijia.storm.sun.dal.ad.mapper.StormSunDevicePoMapper;
import com.baijia.storm.sun.dal.ad.mapper.StormSunWeChatChatroomPoMapper;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.baijia.storm.sun.sal.factory.SunTaskFactory;
import com.baijia.storm.sun.service.control.ControlService;
import com.baijia.storm.sun.service.task.SunTaskService;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class XRobotLeaveChatroomTask
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(XRobotLeaveChatroomTask.class);
    @Resource
    private ControlService controlService;
    @Resource
    private StormSunDevicePoMapper devicePoMapper;
    @Resource
    private StormSunWeChatChatroomPoMapper chatroomPoMapper;
    @Resource
    private SunTaskFactory sunTaskFactory;
    @Resource
    private SunTaskService sunTaskService;
    private Gson gson = new Gson();

    @Override
    @Scheduled(cron="${xrobot.leave.chatroom.cron}")
    public void run() throws Exception {
        List<WeChatroom> weChatroomList;
        Map<String, StormSunDevicePo> devicePoByName = this.devicePoMapper.selectBySpecialized(Byte.valueOf((byte)1)).stream().collect(Collectors.toMap(StormSunDevicePo::getWechatUsername, devicePo -> devicePo));
        int start = 0;
        int limit = 1000;
        while (!CollectionUtils.isEmpty(weChatroomList = this.chatroomPoMapper.selectByPaging((long)start, limit).stream().map(wechatroomPo -> (WeChatroom)this.gson.fromJson(wechatroomPo.getRawContent(), WeChatroom.class)).collect(Collectors.toList()))) {
            this.leaveChatroom(weChatroomList, devicePoByName);
            start += weChatroomList.size();
        }
    }

    public void leaveChatroom(List<WeChatroom> weChatroomList, Map<String, StormSunDevicePo> xRobotByName) throws CustomException {
        Set<String> xRobotNameList = xRobotByName.keySet();
        Map<String, WeChatroom> roomContainsXRobotByRoomname = weChatroomList.stream().filter(wechatRoom -> CollectionUtils.isNotEmpty((Collection)CollectionUtils.intersection((Iterable)wechatRoom.getMemberUsernameList(), (Iterable)xRobotNameList))).collect(Collectors.toMap(WeChatroom::getChatroomName, wechatRoom -> wechatRoom));
        List roomsStatusOk = this.controlService.status(new ArrayList<String>(roomContainsXRobotByRoomname.keySet())).entrySet().stream().filter(entry -> ((ChatroomStatus)entry.getValue()).isOk()).map(Map.Entry::getKey).collect(Collectors.toList());
        roomsStatusOk.stream().map(roomContainsXRobotByRoomname::get).forEach(weChatroom -> {
            Collection xRobotsInChatRoom = CollectionUtils.intersection((Iterable)xRobotNameList, (Iterable)weChatroom.getMemberUsernameList());
            Iterator leaveTaskIterator = this.sunTaskFactory.genInstances4ChatroomLeave(weChatroom.getChatroomName(), xRobotsInChatRoom.size()).iterator();
            xRobotsInChatRoom.forEach(robotName -> {
                StormSunDevicePo devicePo = (StormSunDevicePo)xRobotByName.get(robotName);
                String queueKey = QueueKeyGenerator.genXRobotQueueKey((int)devicePo.getLogicId());
                log.info("x robot {}[{}] will leave chatroom {}[{}].", new Object[]{robotName, devicePo.getMachineInfo(), weChatroom.getChatroomName(), weChatroom.getChatroomNickname()});
                this.sunTaskService.pushTask(queueKey, (SunTask)leaveTaskIterator.next());
            });
        });
    }
}

