/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task;

import com.baijia.storm.sun.api.common.model.SunTask;
import com.baijia.storm.sun.common.util.mail.MailFoo;
import com.baijia.storm.sun.dal.ad.mapper.StormSunAllocationPoMapper;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.baijia.storm.sun.sal.redis.RedisClient;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RedisQueueMonitor
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(RedisQueueMonitor.class);
    private String KEYS_PATTERN_LIKE_CHATROOM = "c_*";
    private String KEYS_PATTERN_LIKE_FRIEND = "f_*";
    private String KEYS_PATTERN_LIKE_XROBOT = "x_*";
    private String KEYS_PATTERN_LIKE_LOGICID = "l_*";
    private List<String> patterns = Arrays.asList(this.KEYS_PATTERN_LIKE_CHATROOM, this.KEYS_PATTERN_LIKE_FRIEND, this.KEYS_PATTERN_LIKE_XROBOT, this.KEYS_PATTERN_LIKE_LOGICID);
    @Resource
    private RedisClient redisClient;
    @Resource
    private StormSunAllocationPoMapper allocationPoMapper;
    @Value(value="${sun_task.timeout.seconds:86400}")
    private long taskTimeoutSeconds;
    @Value(value="${redis.queue.size.maximum:100}")
    private long queueSizeThreshold;
    private Gson gson = new Gson();

    @Override
    @Scheduled(cron="${redis_queue.monitor.cron}")
    public void run() {
        log.info("start checking redis queue");
        HashSet longQueues = Sets.newHashSet();
        HashSet oldQueues = Sets.newHashSet();
        try {
            for (String pattern : this.patterns) {
                for (String key : this.redisClient.keys(pattern)) {
                    switch (this.getQueueStatus(key)) {
                        case QUEUE_TOO_LONG: {
                            longQueues.add(key);
                            break;
                        }
                        case HAS_OLD_TASK: {
                            oldQueues.add(key);
                            break;
                        }
                    }
                }
            }
            StringBuilder resultText = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)longQueues)) {
                resultText.append("\u961f\u5217\u957f\u5ea6\u8d85\u8fc7").append(this.queueSizeThreshold).append("\u7684\u961f\u5217\u6709:\n").append(StringUtils.join((Iterable)longQueues, (String)", ")).append("<br><br>");
            }
            if (CollectionUtils.isNotEmpty((Collection)oldQueues)) {
                resultText.append("\u6709\u8d85\u671f\u4efb\u52a1\u7684\u961f\u5217\u6709: ").append(StringUtils.join((Iterable)oldQueues, (String)", ")).append("<br><br>");
            }
            if (StringUtils.isNotBlank((CharSequence)resultText)) {
                log.info(resultText.toString());
                MailFoo.send((String)"Redis\u961f\u5217\u76d1\u63a7", (Object)resultText);
            }
        }
        catch (Exception e) {
            log.error("", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("checking redis queue ended.");
    }

    private QueueStatus getQueueStatus(String key) {
        SunTask oldestTask = this.parseTaskJson(this.redisClient.lindex(key, 0L));
        if (oldestTask == null) {
            return QueueStatus.OK;
        }
        if (CollectionUtils.isEmpty((Collection)this.allocationPoMapper.selectByQueueKeyAndStatus(key, Byte.valueOf((byte)1)))) {
            this.popExpiredTask(key);
            return QueueStatus.HAS_NO_OWNER;
        }
        long queueSize = this.redisClient.llen(key);
        if (queueSize >= this.queueSizeThreshold) {
            return QueueStatus.QUEUE_TOO_LONG;
        }
        if (this.isTaskTooOld(oldestTask)) {
            return QueueStatus.HAS_OLD_TASK;
        }
        return QueueStatus.OK;
    }

    private SunTask parseTaskJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (SunTask)this.gson.fromJson(json, SunTask.class);
        }
        catch (Exception e) {
            log.warn("got error while parsing task, {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    private int popExpiredTask(String key) {
        int taskCnt = 0;
        SunTask task = this.parseTaskJson(this.redisClient.lindex(key, 0L));
        while (task != null && this.isTaskTooOld(task)) {
            log.info("pop expired task: {} from queue {}", (Object)task, (Object)key);
            this.redisClient.lpop(key);
            ++taskCnt;
            task = this.parseTaskJson(this.redisClient.lindex(key, 0L));
        }
        return taskCnt;
    }

    private boolean isTaskTooOld(SunTask task) {
        if (task == null) {
            return false;
        }
        return task.getCreateTime() + this.taskTimeoutSeconds < System.currentTimeMillis() / 1000L;
    }

    private static enum QueueStatus {
        OK,
        QUEUE_TOO_LONG,
        HAS_OLD_TASK,
        HAS_NO_OWNER;

    }
}

