/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task;

import com.baijia.snowflake.client.SClient;
import com.baijia.storm.sun.api.common.proto.SunApiResponse;
import com.baijia.storm.sun.api.common.proto.SunChat;
import com.baijia.storm.sun.api.common.util.LogUtil;
import com.baijia.storm.sun.api.open.OpenApi;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.baijia.storm.sun.sal.redis.RedisClient;
import com.google.gson.Gson;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class LiveWorker
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(LiveWorker.class);
    public static final long INTERVAL = 500L;
    @Resource
    private RedisClient redisClient;
    @Resource
    private OpenApi openApi;
    @Resource
    private SClient sClient;

    @Override
    @Scheduled(fixedDelay=500L)
    public void run() throws Exception {
        String stuff = this.redisClient.lpop("storm_sun_live_task_queue");
        if (stuff == null) {
            return;
        }
        Long traceId = this.genTraceId();
        log.info("{} STUFF {}", (Object)traceId, (Object)stuff);
        SunChat sunChat = (SunChat)new Gson().fromJson(stuff, SunChat.class);
        SunApiResponse response = this.openApi.send(sunChat);
        if (response.getCode() == 0) {
            log.info("{} SUCCESS", (Object)traceId);
        } else {
            log.error("{} FAILED {} {}", new Object[]{traceId, LogUtil.toString((Object)response), stuff});
        }
    }

    private Long genTraceId() {
        try {
            return (Long)this.sClient.get(1).get(0);
        }
        catch (Exception e) {
            log.error("SYS_ERROR", (Throwable)e);
            return -1L;
        }
    }
}

