/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task;

import com.baijia.storm.sun.common.util.Switch;
import com.baijia.storm.sun.common.util.mail.MailFoo;
import com.baijia.storm.sun.dal.ad.mapper.StormSunDevicePoMapper;
import com.baijia.storm.sun.dal.ad.mapper.StormSunHeartbeatPoMapper;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.dal.po.StormSunHeartbeatPo;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.google.common.collect.Maps;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import sword.lib.FieldExtractor;

@Component
public class HeartbeatMonitor
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private static final long TIMEOUT_MS = 60000L;
    private Set<Integer> last = new HashSet<Integer>();
    @Resource
    private StormSunHeartbeatPoMapper stormSunHeartbeatPoMapper;
    @Resource
    private StormSunDevicePoMapper stormSunDevicePoMapper;
    @Resource
    private Configuration freemarkerConfig;
    @Resource
    Switch sw;
    @Value(value="${path.heartbeat.report.tpl}")
    private String heartbeatReportLocation;

    @Override
    @Scheduled(cron="${heartbeat.monitor.cron}")
    public void run() throws Exception {
        if (!this.sw.heartbeat) {
            return;
        }
        long cur = System.currentTimeMillis();
        List allPoList = this.stormSunHeartbeatPoMapper.selectAll();
        LinkedList<StormSunHeartbeatPo> heartbeatInTheMeantime = new LinkedList<StormSunHeartbeatPo>();
        for (StormSunHeartbeatPo heartbeatPo : allPoList) {
            if (heartbeatPo.getUpdateTime().getTime() <= cur - 60000L) continue;
            heartbeatInTheMeantime.add(heartbeatPo);
        }
        List devicePoList = this.stormSunDevicePoMapper.selectByStatus(Byte.valueOf((byte)0));
        List all = FieldExtractor.extract((List)devicePoList, (String)"logicId", (Object[])new Integer[0]);
        HashSet alive = new HashSet(FieldExtractor.extract(heartbeatInTheMeantime, (String)"logicId", (Object[])new Integer[0]));
        HashSet<Integer> dead = new HashSet<Integer>();
        for (Integer e : all) {
            if (alive.contains(e)) continue;
            dead.add(e);
        }
        HashSet<Integer> deltaDead = new HashSet<Integer>(dead);
        deltaDead.removeAll(this.last);
        HashSet<Integer> deltaAlive = new HashSet<Integer>(this.last);
        deltaAlive.removeAll(dead);
        this.last = dead;
        if (!deltaDead.isEmpty() || !deltaAlive.isEmpty()) {
            Map<String, Object> params = this.generateReportData(devicePoList, allPoList, deltaDead, deltaAlive);
            MailFoo.send((String)"HeartbeatMonitor", (Object)this.heartbeatInfoRender(params));
        }
    }

    private String heartbeatInfoRender(Map<String, Object> params) throws IOException, TemplateException {
        Template tpl = this.freemarkerConfig.getTemplate(this.heartbeatReportLocation);
        StringWriter writer = new StringWriter();
        tpl.process(params, (Writer)writer);
        return writer.toString();
    }

    private Map<String, Object> generateReportData(List<StormSunDevicePo> devicePoList, List<StormSunHeartbeatPo> heartbeatPoList, Collection<Integer> deltaDead, Collection<Integer> deltaAlive) {
        long currentTimestamp = System.currentTimeMillis();
        Map<Integer, ReporterData> dataMap = devicePoList.stream().map(devicePo -> {
            ReporterData reporterData = new ReporterData();
            reporterData.setLogicId(devicePo.getLogicId());
            reporterData.setWechatUsername(devicePo.getWechatUsername());
            reporterData.setMachineInfo(devicePo.getMachineInfo());
            reporterData.setIpv4(devicePo.getIp());
            reporterData.setPublicIpv4(devicePo.getPublicIpv4());
            reporterData.setCluster(devicePo.getCluster());
            reporterData.setStatus(NodeStatus.UNKNOWN.getDesc());
            return reporterData;
        }).collect(Collectors.toMap(ReporterData::getLogicId, data -> data));
        heartbeatPoList.forEach(heartbeatPo -> {
            ReporterData reporterData = (ReporterData)dataMap.get(heartbeatPo.getLogicId());
            if (reporterData != null) {
                reporterData.setStatus(heartbeatPo.getUpdateTime().getTime() + 60000L > currentTimestamp ? NodeStatus.ALIVE.getDesc() : NodeStatus.DEAD.getDesc());
            }
        });
        List deadList = dataMap.entrySet().stream().filter(entry -> NodeStatus.DEAD.equals((Object)NodeStatus.fromDesc(((ReporterData)entry.getValue()).getStatus()))).map(Map.Entry::getKey).collect(Collectors.toList());
        CollectionUtils.union(deltaDead, deltaAlive).forEach(logicId -> {
            ReporterData reporterData = (ReporterData)dataMap.get(logicId);
            if (reporterData != null) {
                reporterData.setDelta("\u25b3");
            }
        });
        List reporterDataList = dataMap.values().stream().sorted(Comparator.comparing(this::calcWeight).reversed().thenComparing(ReporterData::getLogicId)).collect(Collectors.toList());
        HashMap result = Maps.newHashMapWithExpectedSize((int)5);
        result.put("reporterDatas", reporterDataList);
        result.put("deltaDead", deltaDead);
        result.put("deltaAlive", deltaAlive);
        result.put("deadList", deadList);
        result.put("title", "\u5fc3\u8df3\u76d1\u63a7\u62a5\u544a");
        return result;
    }

    private int calcWeight(ReporterData data) {
        int weight = data.getDelta() == null ? 0 : 1000;
        return weight += NodeStatus.fromDesc(data.getStatus()).getWeight();
    }

    public static class ReporterData {
        Integer logicId;
        String wechatUsername;
        String machineInfo;
        String ipv4;
        String publicIpv4;
        Integer cluster;
        String status;
        String delta;

        public Integer getLogicId() {
            return this.logicId;
        }

        public String getWechatUsername() {
            return this.wechatUsername;
        }

        public String getMachineInfo() {
            return this.machineInfo;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public String getPublicIpv4() {
            return this.publicIpv4;
        }

        public Integer getCluster() {
            return this.cluster;
        }

        public String getStatus() {
            return this.status;
        }

        public String getDelta() {
            return this.delta;
        }

        public void setLogicId(Integer logicId) {
            this.logicId = logicId;
        }

        public void setWechatUsername(String wechatUsername) {
            this.wechatUsername = wechatUsername;
        }

        public void setMachineInfo(String machineInfo) {
            this.machineInfo = machineInfo;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public void setPublicIpv4(String publicIpv4) {
            this.publicIpv4 = publicIpv4;
        }

        public void setCluster(Integer cluster) {
            this.cluster = cluster;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setDelta(String delta) {
            this.delta = delta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReporterData)) {
                return false;
            }
            ReporterData other = (ReporterData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$logicId = this.getLogicId();
            Integer other$logicId = other.getLogicId();
            if (this$logicId == null ? other$logicId != null : !((Object)this$logicId).equals(other$logicId)) {
                return false;
            }
            String this$wechatUsername = this.getWechatUsername();
            String other$wechatUsername = other.getWechatUsername();
            if (this$wechatUsername == null ? other$wechatUsername != null : !this$wechatUsername.equals(other$wechatUsername)) {
                return false;
            }
            String this$machineInfo = this.getMachineInfo();
            String other$machineInfo = other.getMachineInfo();
            if (this$machineInfo == null ? other$machineInfo != null : !this$machineInfo.equals(other$machineInfo)) {
                return false;
            }
            String this$ipv4 = this.getIpv4();
            String other$ipv4 = other.getIpv4();
            if (this$ipv4 == null ? other$ipv4 != null : !this$ipv4.equals(other$ipv4)) {
                return false;
            }
            String this$publicIpv4 = this.getPublicIpv4();
            String other$publicIpv4 = other.getPublicIpv4();
            if (this$publicIpv4 == null ? other$publicIpv4 != null : !this$publicIpv4.equals(other$publicIpv4)) {
                return false;
            }
            Integer this$cluster = this.getCluster();
            Integer other$cluster = other.getCluster();
            if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$delta = this.getDelta();
            String other$delta = other.getDelta();
            return !(this$delta == null ? other$delta != null : !this$delta.equals(other$delta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReporterData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $logicId = this.getLogicId();
            result = result * 59 + ($logicId == null ? 43 : ((Object)$logicId).hashCode());
            String $wechatUsername = this.getWechatUsername();
            result = result * 59 + ($wechatUsername == null ? 43 : $wechatUsername.hashCode());
            String $machineInfo = this.getMachineInfo();
            result = result * 59 + ($machineInfo == null ? 43 : $machineInfo.hashCode());
            String $ipv4 = this.getIpv4();
            result = result * 59 + ($ipv4 == null ? 43 : $ipv4.hashCode());
            String $publicIpv4 = this.getPublicIpv4();
            result = result * 59 + ($publicIpv4 == null ? 43 : $publicIpv4.hashCode());
            Integer $cluster = this.getCluster();
            result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $delta = this.getDelta();
            result = result * 59 + ($delta == null ? 43 : $delta.hashCode());
            return result;
        }

        public String toString() {
            return "HeartbeatMonitor.ReporterData(logicId=" + this.getLogicId() + ", wechatUsername=" + this.getWechatUsername() + ", machineInfo=" + this.getMachineInfo() + ", ipv4=" + this.getIpv4() + ", publicIpv4=" + this.getPublicIpv4() + ", cluster=" + this.getCluster() + ", status=" + this.getStatus() + ", delta=" + this.getDelta() + ")";
        }
    }

    private static enum NodeStatus {
        ALIVE("Alive", 1),
        DEAD("Dead", 2),
        UNKNOWN("Unknown", 3);

        String desc;
        int weight;

        private NodeStatus(String desc, int weight) {
            this.desc = desc;
            this.weight = weight;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getWeight() {
            return this.weight;
        }

        public static NodeStatus fromDesc(String desc) {
            for (NodeStatus s : NodeStatus.values()) {
                if (!s.getDesc().equals(desc)) continue;
                return s;
            }
            return UNKNOWN;
        }
    }
}

