/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task;

import com.baijia.storm.sun.api.common.exception.CustomException;
import com.baijia.storm.sun.api.common.model.QueueKey;
import com.baijia.storm.sun.api.common.util.LogUtil;
import com.baijia.storm.sun.dal.ad.boost.UnitBoost;
import com.baijia.storm.sun.dal.ad.mapper.StormSunAllocationPoMapper;
import com.baijia.storm.sun.dal.po.StormSunAllocationPo;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.baijia.storm.sun.sal.factory.SunTaskFactory;
import com.baijia.storm.sun.service.control.ControlService;
import com.baijia.storm.sun.service.task.SunTaskService;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import sword.lib.Defaultor;
import sword.lib.FieldExtractor;
import sword.lib.Mapper;

@Component
public class DistinctRoleMonitor
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(DistinctRoleMonitor.class);
    public static final long INTERVAL = 60000L;
    private static final long LESS_TIME_THR = 300000L;
    @Resource
    private StormSunAllocationPoMapper stormSunAllocationPoMapper;
    @Resource
    private ControlService controlService;
    @Resource
    private SunTaskFactory sunTaskFactory;
    @Resource
    private SunTaskService sunTaskService;
    @Resource
    private UnitBoost unitBoost;

    @Override
    @Scheduled(fixedDelay=60000L)
    public void run() throws Exception {
        List chatroomAllocationList = this.stormSunAllocationPoMapper.selectByQueueKeyLike("c_%");
        this.more(chatroomAllocationList);
    }

    private void less(List<StormSunAllocationPo> chatroomAllocationList) {
        try {
            if (CollectionUtils.isEmpty(chatroomAllocationList)) {
                return;
            }
            HashMap<String, List> group = new HashMap<String, List>();
            for (StormSunAllocationPo stormSunAllocationPo : chatroomAllocationList) {
                QueueKey queueKey = new QueueKey(stormSunAllocationPo.getQueueKey());
                List list = (List)Defaultor.get(group.get(queueKey.getEntity()), new LinkedList());
                list.add(stormSunAllocationPo);
                group.put(queueKey.getEntity(), list);
            }
            for (Map.Entry entry : group.entrySet()) {
                List list = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                this.disposalLess(list);
            }
        }
        catch (Exception e) {
            log.error("LESS chatroomAllocationList[" + LogUtil.toString(chatroomAllocationList) + "]", (Throwable)e);
        }
    }

    private void disposalLess(List<StormSunAllocationPo> list) throws NoSuchFieldException, IllegalAccessException, CustomException {
        boolean masterManaged = false;
        boolean slaveManaged = false;
        long maxMasterUpdateTime = -1L;
        for (StormSunAllocationPo allocationPo : list) {
            if (allocationPo.getStatus().equals((byte)0)) continue;
            QueueKey queueKey = new QueueKey(allocationPo.getQueueKey());
            if (queueKey.getRole().equals("m")) {
                masterManaged = true;
                if (allocationPo.getUpdateTime().getTime() <= maxMasterUpdateTime) continue;
                maxMasterUpdateTime = allocationPo.getUpdateTime().getTime();
                continue;
            }
            if (queueKey.getRole().equals("s")) {
                slaveManaged = true;
                continue;
            }
            throw new UnsupportedOperationException();
        }
        long cur = System.currentTimeMillis();
        if (masterManaged && !slaveManaged && cur - maxMasterUpdateTime > 300000L) {
            log.info("disposalLess m[{}] s[{}] cur[{}] maxMasterUpdateTime[{}], list[{}]", new Object[]{masterManaged, slaveManaged, cur, maxMasterUpdateTime, LogUtil.toString(list)});
            String chatroom = new QueueKey(list.get(0).getQueueKey()).getEntity();
            int unit = this.unitBoost.queryUnit(chatroom);
            this.controlService.allocateANewSlave(unit, chatroom);
        }
    }

    private void more(List<StormSunAllocationPo> chatroomAllocationList) {
        try {
            if (CollectionUtils.isEmpty(chatroomAllocationList)) {
                return;
            }
            LinkedList<StormSunAllocationPo> allocationCM = new LinkedList<StormSunAllocationPo>();
            for (StormSunAllocationPo allocationPo : chatroomAllocationList) {
                QueueKey queueKey = new QueueKey(allocationPo.getQueueKey());
                if (!queueKey.getRole().equals("s") && !queueKey.getRole().equals("m") || allocationPo.getStatus() != 1) continue;
                allocationCM.add(allocationPo);
            }
            if (CollectionUtils.isEmpty(allocationCM)) {
                return;
            }
            Map group = Mapper.group(allocationCM, (String)"queueKey", (Object[])new String[0]);
            for (Map.Entry entry : group.entrySet()) {
                List list = (List)entry.getValue();
                if (list == null || list.size() <= 1) continue;
                this.disposalMore(list);
            }
        }
        catch (Exception e) {
            log.error("MORE chatroomAllocationList[" + LogUtil.toString(chatroomAllocationList) + "]", (Throwable)e);
        }
    }

    private void disposalMore(List<StormSunAllocationPo> list) throws NoSuchFieldException, IllegalAccessException {
        Collections.sort(list, new Comparator<StormSunAllocationPo>(){

            @Override
            public int compare(StormSunAllocationPo lhs, StormSunAllocationPo rhs) {
                return lhs.getId() - rhs.getId();
            }
        });
        log.info("disposalMore list[{}]", (Object)LogUtil.toString(list));
        List<StormSunAllocationPo> subList = list.subList(1, list.size());
        log.info("disposalMore subList[{}]", (Object)LogUtil.toString(subList));
        List idList = FieldExtractor.extract(subList, (String)"id", (Object[])new Integer[0]);
        this.stormSunAllocationPoMapper.updateStatusByIdList(idList, Byte.valueOf((byte)0));
    }
}

