/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner.Task;

import com.baijia.storm.sun.api.common.model.SunTask;
import com.baijia.storm.sun.api.common.util.LogUtil;
import com.baijia.storm.sun.api.common.util.QueueKeyGenerator;
import com.baijia.storm.sun.dal.ad.mapper.StormSunDevicePoMapper;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.runner.Task.RunnerTask;
import com.baijia.storm.sun.sal.factory.SunTaskFactory;
import com.baijia.storm.sun.service.task.SunTaskService;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ChatroomPoolWorker
implements RunnerTask {
    private static final Logger log = LoggerFactory.getLogger(ChatroomPoolWorker.class);
    @Resource
    private StormSunDevicePoMapper stormSunDevicePoMapper;
    @Resource
    private SunTaskFactory sunTaskFactory;
    @Resource
    private SunTaskService sunTaskService;

    @Override
    @Scheduled(cron="${chatroom_pool.worker.cron}")
    public void run() throws Exception {
        List availableDevcieList = this.stormSunDevicePoMapper.selectByStatus(Byte.valueOf((byte)0));
        List<StormSunDevicePo> masterList = availableDevcieList.stream().filter(device -> device.getSpecialized() == 2).collect(Collectors.toList());
        List xUsernameList = availableDevcieList.stream().filter(device -> device.getSpecialized() == 1).map(StormSunDevicePo::getWechatUsername).collect(Collectors.toList());
        masterList.forEach(master -> {
            SunTask prepareTask = this.sunTaskFactory.genInstance4PrepareChatroom(xUsernameList, UUID.randomUUID().toString());
            this.sunTaskService.pushTask(QueueKeyGenerator.genLogicIdQueueKey((int)master.getLogicId()), prepareTask);
            log.info("master[{}] task[{}]", (Object)master.getLogicId(), (Object)LogUtil.toString((Object)prepareTask));
        });
    }
}

