/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.runner;

import java.io.IOException;
import java.net.ServerSocket;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class Runner {
    private static final Logger log = LoggerFactory.getLogger(Runner.class);
    private static ServerSocket lock;
    @Resource
    private ThreadPoolTaskScheduler scheduler;

    public static void main(String[] args) {
        final ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("ctx-runner.xml");
        final Runner runner = (Runner)context.getBean(Runner.class);
        runner.start((ApplicationContext)context);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    runner.stop();
                }
                catch (Throwable e) {
                    log.error("something goes wrong when stopping scheduler, {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
        }, "runner-shutdown-listener"));
    }

    private void start(ApplicationContext context) {
        try {
            lock = new ServerSocket((Integer)context.getBean("socketLock", Integer.class));
        }
        catch (IOException e) {
            log.error("[Socket Lock]", (Throwable)e);
            System.exit(1);
        }
    }

    private void stop() {
        this.scheduler.shutdown();
    }
}

