/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.talk.util;

import com.baijia.storm.sun.nursery.talk.proto.TuningRequest;
import com.baijia.storm.sun.nursery.talk.util.NurseryKeyGenerator;
import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AutoReplyClient {
    private static final Logger log = LoggerFactory.getLogger(AutoReplyClient.class);
    protected static String host = "http://www.tuling123.com/openapi/api";
    protected static String TUNING_API_KEY = "547a221044f646d8927a30962c6706e7";
    protected static String DEFAULT_RESPONSE = "\u5475\u5475";
    protected static String RESPONSE_TEXT_SEP = "text";

    public static String autoReply(String msg, String infoKey) {
        if (msg == null) {
            return DEFAULT_RESPONSE;
        }
        if (infoKey == null) {
            infoKey = NurseryKeyGenerator.defaultKey();
        }
        return AutoReplyClient.query(msg, infoKey);
    }

    private static String query(String msg, String infoKey) {
        TuningRequest request = new TuningRequest();
        request.setInfo(msg);
        request.setUserid(infoKey);
        request.setKey(TUNING_API_KEY);
        String response = AutoReplyClient.httpPost(request);
        log.info("[AutoReplyClient] [query] [request:{} response:{}] ", (Object)msg, (Object)response);
        if (response == null) {
            return DEFAULT_RESPONSE;
        }
        int startIndex = response.indexOf(RESPONSE_TEXT_SEP) + RESPONSE_TEXT_SEP.length();
        if (startIndex != -1) {
            int sepIndex = response.indexOf("\",", startIndex);
            if (sepIndex != -1) {
                return response.substring(startIndex, sepIndex).replace(":", "").replace("\"", "").trim();
            }
            sepIndex = response.indexOf("\"}", startIndex);
            if (sepIndex != -1) {
                return response.substring(startIndex, sepIndex).replace(":", "").replace("\"", "").trim();
            }
            return response.substring(startIndex).replace(":", "").replace("\"", "").trim();
        }
        return DEFAULT_RESPONSE;
    }

    private static String httpPost(TuningRequest request) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost method = new HttpPost(host);
            StringEntity stringEntity = new StringEntity(new Gson().toJson((Object)request, TuningRequest.class), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            method.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method);
            if (httpResponse == null || httpResponse.getStatusLine() == null) {
                log.error("[AutoReplyClient] [httpPost] SYS_ERROR [httpResponse is invalid]");
                return null;
            }
            if (200 != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[AutoReplyClient] [httpPost] SYS_ERROR [httpStatus != 200]");
                log.error("[AutoReplyClient] [httpPost] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                return null;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[AutoReplyClient] [httpPost] SYS_ERROR [httpEntity is null]");
                return null;
            }
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("[AutoReplyClient] [httpPost] SYS_ERROR", (Throwable)e);
            return null;
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception e) {
                    log.error("[AutoReplyClient] [httpPost] SYS_ERROR [free resource failed]", (Throwable)e);
                }
            }
        }
    }
}

