/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.talk.model.chat.impl;

import com.baijia.storm.sun.nursery.talk.model.chat.ChatPool;
import com.baijia.storm.sun.nursery.talk.util.RandUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HistoryChatPool
implements ChatPool {
    private static final Logger log = LoggerFactory.getLogger(HistoryChatPool.class);
    @Value(value="${history_pool_size}")
    private int poolSize;
    @Value(value="${default_content}")
    private String defaultContent;
    private Set<String> caches = Collections.synchronizedSet(new HashSet());

    @Override
    public String getContent(String src, String key) {
        return this.syncGetContent();
    }

    @Override
    public boolean available() {
        return this.syncCheckAvailable();
    }

    @Override
    public boolean putContent(String content) {
        if (content == null) {
            return false;
        }
        return this.syncPutContent(content);
    }

    private synchronized boolean syncPutContent(String content) {
        if (!this.caches.contains(content)) {
            this.caches.add(content);
            this.syncKnockOut();
            return true;
        }
        return false;
    }

    private synchronized boolean syncCheckAvailable() {
        return !this.caches.isEmpty();
    }

    public synchronized String syncGetContent() {
        String randKey = this.getRandValue();
        return randKey == null ? this.defaultContent : randKey;
    }

    private synchronized void syncKnockOut() {
        Iterator<String> itr;
        if (this.caches.size() >= this.poolSize && (itr = this.caches.iterator()).hasNext()) {
            log.info("[{}] [syncKnockOut] [knock out: {}]", (Object)this.getClass().getSimpleName(), (Object)itr.next());
            itr.remove();
        }
    }

    private synchronized String getRandValue() {
        int rand = RandUtil.nextInt(0, this.caches.size());
        for (String next : this.caches) {
            if (--rand != 0) continue;
            return next;
        }
        return null;
    }
}

