/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.talk.action.model;

import com.baijia.storm.sun.nursery.talk.action.constant.NurseryParamsKey;
import com.baijia.storm.sun.nursery.talk.action.model.NurseryAction;
import com.baijia.storm.sun.nursery.talk.util.NurseryKeyGenerator;
import com.google.gson.Gson;
import java.util.Map;

public abstract class BaseNurseryAction
implements NurseryAction {
    protected Map<String, Object> params;

    public BaseNurseryAction(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public String getKey() {
        if (this.params == null) {
            return NurseryKeyGenerator.defaultKey();
        }
        String sponsor = (String)this.params.get(NurseryParamsKey.PARAM_KEY_SPONSOR);
        String[] receivers = (String[])this.params.get(NurseryParamsKey.PARAM_KEY_RECEIVERS);
        return NurseryKeyGenerator.makeKey(sponsor, receivers);
    }

    @Override
    public boolean valid() {
        if (this.params == null) {
            return false;
        }
        if (this.params.get(NurseryParamsKey.PARAM_KEY_SPONSOR) == null) {
            return false;
        }
        if (this.params.get(NurseryParamsKey.PARAM_KEY_RECEIVERS) == null) {
            return false;
        }
        return this.params.get(NurseryParamsKey.PARAM_KEY_CHAT_TIME) != null;
    }

    @Override
    public Map<String, Object> getParamsMap() {
        return this.params;
    }

    public String toString() {
        return String.format("{%s key:[%s], params:[%s]}", this.getClass().getSimpleName(), this.getKey().toString(), new Gson().toJson(this.params));
    }
}

