/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.talk.action.manager;

import com.baijia.storm.sun.api.common.exception.BizException;
import com.baijia.storm.sun.api.common.exception.SysException;
import com.baijia.storm.sun.api.common.model.SunTask;
import com.baijia.storm.sun.api.common.util.QueueKeyGenerator;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.nursery.talk.action.dispatcher.NurseryActionDispatcher;
import com.baijia.storm.sun.nursery.talk.action.model.NurseryAction;
import com.baijia.storm.sun.nursery.talk.action.model.impl.SetUpConversationAction;
import com.baijia.storm.sun.nursery.talk.model.chat.ChatSourceManager;
import com.baijia.storm.sun.nursery.talk.util.GeneratorUtil;
import com.baijia.storm.sun.sal.factory.SunTaskFactory;
import com.baijia.storm.sun.sal.redis.RedisClient;
import com.baijia.storm.sun.service.task.SunTaskService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NurseryManager {
    private static final Logger log = LoggerFactory.getLogger(NurseryManager.class);
    @Resource
    private RedisClient redisClient;
    @Resource
    private SunTaskFactory sunTaskFactory;
    @Resource
    private SunTaskService sunTaskService;
    @Resource
    private NurseryManager nurseryManager;
    @Resource
    private NurseryActionDispatcher nurseryActionDispatcher;
    @Resource
    private ChatSourceManager chatSourceManager;
    @Value(value="${set_up_chat_ratio}")
    private double randActionGenerateRatio;
    private List<StormSunDevicePo> allRobots = null;
    private Map<String, StormSunDevicePo> userName2DevicePoMapper = new HashMap<String, StormSunDevicePo>();
    private int robotsListIndex = 0;

    public boolean setAllRobots(List<StormSunDevicePo> allRobots) {
        if (allRobots != null && !allRobots.isEmpty()) {
            this.allRobots = allRobots;
            Collections.shuffle(allRobots);
            this.genUsername2DevicePoMapper();
            this.robotsListIndex = 0;
            return true;
        }
        return false;
    }

    public Map<String, StormSunDevicePo> getUserName2DevicePoMapper() {
        return this.userName2DevicePoMapper;
    }

    public List<StormSunDevicePo> getAllRobots() {
        return this.allRobots;
    }

    public void newTalk(String sponsor, String[] receivers, String content) throws BizException, SysException {
        if (sponsor == null || receivers == null || content == null || content.isEmpty()) {
            throw new BizException();
        }
        if (this.userName2DevicePoMapper.get(sponsor) == null) {
            throw new SysException();
        }
        log.info("[NurseryManager] [new talk task] [sponsor:{}, receivers:{}, content:{}]", new Object[]{sponsor, Arrays.toString(receivers), content});
        Integer sponsorLogicId = this.userName2DevicePoMapper.get(sponsor).getLogicId();
        SunTask sunTask = (SunTask)this.sunTaskFactory.genInstances4Chat(Integer.valueOf(1), content, Arrays.asList(receivers), Integer.valueOf(2)).get(0);
        this.sunTaskService.pushTask(QueueKeyGenerator.genLogicIdQueueKey((int)sponsorLogicId), sunTask);
    }

    private void genUsername2DevicePoMapper() {
        if (this.allRobots == null) {
            return;
        }
        this.userName2DevicePoMapper = new HashMap<String, StormSunDevicePo>();
        for (StormSunDevicePo po : this.allRobots) {
            this.userName2DevicePoMapper.put(po.getWechatUsername(), po);
        }
    }

    public void pushAction(NurseryAction action) throws Exception {
        this.nurseryActionDispatcher.pushAction(action);
    }

    public SetUpConversationAction randSetUpConversationAction() {
        if (this.allRobots == null) {
            return null;
        }
        if (this.robotsListIndex >= this.allRobots.size()) {
            this.robotsListIndex = 0;
        }
        return GeneratorUtil.randSetUpConvActionImpl(this.allRobots, this.robotsListIndex++, this.randActionGenerateRatio);
    }

    public String getContent(String src, String key) {
        return this.chatSourceManager.getContent(src, key);
    }
}

