/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.talk.action.filter.impl;

import com.baijia.storm.sun.nursery.talk.action.constant.NurseryActionType;
import com.baijia.storm.sun.nursery.talk.action.constant.NurseryParamsKey;
import com.baijia.storm.sun.nursery.talk.action.filter.BaseFilter;
import com.baijia.storm.sun.nursery.talk.action.model.NurseryAction;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NurseryTimeFilter
extends BaseFilter {
    private static final Logger log = LoggerFactory.getLogger(NurseryTimeFilter.class);
    @Value(value="${chat_time_up_limit}")
    private String chatTimeUpLimit = "20:00:00";
    @Value(value="${chat_time_down_limit}")
    private String chatTimeDownLimit = "10:00:00";
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

    @Override
    protected boolean doFilter(NurseryAction action) throws Exception {
        long occurTimeInMills = (Long)action.getParamsMap().get(NurseryParamsKey.PARAM_KEY_CHAT_TIME);
        String occurTime = timeFormat.format(occurTimeInMills);
        return this.chatTimeDownLimit.compareTo(occurTime) > 0 || occurTime.compareTo(this.chatTimeUpLimit) > 0;
    }

    @Override
    public Set<NurseryActionType> watchedActionTypeSet() {
        return new HashSet<NurseryActionType>(){
            {
                this.add(NurseryActionType.ACTION_SET_UP_CHAT);
            }
        };
    }
}

