/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.talk.action.dispatcher;

import com.baijia.storm.sun.nursery.talk.action.filter.NurseryFilter;
import com.baijia.storm.sun.nursery.talk.action.handler.NurseryActionHandler;
import com.baijia.storm.sun.nursery.talk.action.manager.NurseryManager;
import com.baijia.storm.sun.nursery.talk.action.model.NurseryAction;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NurseryActionDispatcher {
    private static final Logger log = LoggerFactory.getLogger(NurseryActionDispatcher.class);
    @Resource
    private NurseryManager nurseryManager;
    @Value(value="${dispatcher_queue_size}")
    private int maxQueueSize;
    @Resource(name="actionFilterList")
    private List<NurseryFilter> filterList;
    @Resource(name="actionHandlerList")
    private List<NurseryActionHandler> handlerList;
    public LinkedBlockingQueue<NurseryAction> actionQueue = new LinkedBlockingQueue();

    public void dispatch() throws Exception {
        if (this.actionQueue.isEmpty()) {
            return;
        }
        NurseryAction action = this.actionQueue.take();
        log.info("[NurseryActionDispatcher] [dispatch] [dispatched action:{}, residual action:{}]", (Object)action.toString(), (Object)this.actionQueue.size());
        for (NurseryFilter filter : this.filterList) {
            if (!filter.filter(action)) continue;
            log.info("[NurseryActionDispatcher] [dispatch] [action be filtered:{} by filter:{}]", (Object)action.toString(), (Object)filter.getClass().getSimpleName());
            return;
        }
        for (NurseryActionHandler handler : this.handlerList) {
            handler.act(action, this.nurseryManager);
        }
    }

    public void pushAction(NurseryAction action) throws InterruptedException {
        if (action == null) {
            return;
        }
        if (this.actionQueue.size() > this.maxQueueSize) {
            log.info("[NurseryActionDispatcher] [pushAction] [queue has too many messages, drop it! remain action:{}]", (Object)this.actionQueue.size());
            return;
        }
        log.info("[NurseryActionDispatcher] [pushAction] [pushed action:{}, remain action:{}]", (Object)action.toString(), (Object)this.actionQueue.size());
        this.actionQueue.put(action);
    }
}

