/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.social.strategy.impl;

import com.baijia.storm.sun.api.common.dto.request.SocialMaterialRequest;
import com.baijia.storm.sun.api.common.dto.response.SocialMaterialData;
import com.baijia.storm.sun.nursery.social.cache.SocialMaterialCache;
import com.baijia.storm.sun.nursery.social.strategy.AllocationStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalAllocationStrategy
implements AllocationStrategy {
    private static final Logger log = LoggerFactory.getLogger(NormalAllocationStrategy.class);
    private Random random = new Random();

    @Override
    public SocialMaterialData allocate(SocialMaterialRequest request, SocialMaterialCache cache) throws Exception {
        SocialMaterialData respData = new SocialMaterialData();
        respData.setPersonalQrcodeList(this.randFetchQrcodeUrl(request, cache.getPersonalQrcodeUrlList(), request.getPersonalQrcodeCount()));
        respData.setChatroomQrcodeList(this.randFetchQrcodeUrl(request, cache.getChatroomQrcodeUrlList(), request.getChatroomQrcodeCount()));
        respData.setSubscriptionQrcodeList(this.randFetchQrcodeUrl(request, cache.getSubscriptionQrcodeUrlList(), request.getSubscriptionQrcodeCount()));
        return respData;
    }

    private List<String> randFetchQrcodeUrl(SocialMaterialRequest request, List<String> qrcodeList, int size) {
        if (qrcodeList.isEmpty()) {
            log.warn("allocate failed: empty qrcode url list!");
            return null;
        }
        ArrayList<String> qrcodeUrlListDump = new ArrayList<String>(qrcodeList);
        if (request.getLocalUrlList() != null) {
            qrcodeUrlListDump.removeAll(request.getLocalUrlList());
        }
        return this.randFetchQrcode(size, qrcodeUrlListDump);
    }

    private List<String> randFetchQrcode(int fetchSize, List<String> qrcodeList) {
        if (qrcodeList == null || qrcodeList.size() <= fetchSize) {
            log.info("not enough qrcode url for allocated");
            return qrcodeList;
        }
        ArrayList<String> rst = new ArrayList<String>(fetchSize);
        int listInitSize = qrcodeList.size();
        int i = 0;
        while (i < fetchSize) {
            int randRange = listInitSize - i;
            int randIndex = this.random.nextInt(randRange);
            String randUrl = qrcodeList.get(randIndex);
            rst.add(randUrl);
            qrcodeList.set(randIndex, qrcodeList.get(randRange - 1));
            qrcodeList.set(randRange - 1, randUrl);
            ++i;
        }
        return rst;
    }

    @Override
    public String getName() {
        return "normal";
    }
}

