/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.social.service.impl;

import com.baijia.storm.sun.api.common.conf.BizConf;
import com.baijia.storm.sun.api.common.dto.request.SocialMaterialRequest;
import com.baijia.storm.sun.api.common.dto.response.SocialMaterialData;
import com.baijia.storm.sun.api.common.proto.SocialMaterialResponse;
import com.baijia.storm.sun.nursery.SocialMaterialManager;
import com.baijia.storm.sun.nursery.social.exception.ParamErrorException;
import com.baijia.storm.sun.nursery.social.exception.UnSufficientException;
import com.baijia.storm.sun.nursery.social.service.SocialMaterialService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SocialMaterialServiceImpl
implements SocialMaterialService {
    private static final Logger log = LoggerFactory.getLogger(SocialMaterialServiceImpl.class);
    @Resource
    private SocialMaterialManager socialMaterialManager;

    @Override
    public SocialMaterialResponse querySocialMaterial(SocialMaterialRequest request) {
        try {
            SocialMaterialData responseData = this.socialMaterialManager.allocate(request);
            return this.buildSuccessResponse(responseData);
        }
        catch (ParamErrorException e) {
            log.error("query social material param exception, request: {}", (Object)BizConf.gson.toJson((Object)request));
            return this.buildFailedResponse(-1, "param error");
        }
        catch (UnSufficientException e) {
            log.error("query social material un sufficient exception, request: {}", (Object)BizConf.gson.toJson((Object)request));
            return this.buildFailedResponse(-2, "biz error");
        }
        catch (Exception e) {
            log.error("query social material exception, request: {}", (Object)BizConf.gson.toJson((Object)request), (Object)e);
            return this.buildFailedResponse(-3, "sys error");
        }
    }

    private SocialMaterialResponse buildSuccessResponse(SocialMaterialData data) {
        SocialMaterialResponse response = new SocialMaterialResponse();
        response.setCode(Integer.valueOf(0));
        response.setMsg("success");
        response.setData(data);
        return response;
    }

    private SocialMaterialResponse buildFailedResponse(int code, String msg) {
        SocialMaterialResponse response = new SocialMaterialResponse();
        response.setCode(Integer.valueOf(code));
        response.setMsg(msg);
        response.setData(null);
        return response;
    }
}

