/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery.social.loader.impl;

import com.baijia.storm.lib.model.QrCodeChatroomRel;
import com.baijia.storm.sun.api.common.conf.BizConf;
import com.baijia.storm.sun.dal.po.StormSunWeChatQrCodeChatroomRelPo;
import com.baijia.storm.sun.dal.um.boost.ChatroomBoost;
import com.baijia.storm.sun.dal.um.mapper.AccountMapper;
import com.baijia.storm.sun.dal.um.mapper.StormSunWeChatQrCodeChatroomRelPoMapper;
import com.baijia.storm.sun.nursery.social.cache.SocialMaterialCache;
import com.baijia.storm.sun.nursery.social.loader.SocialMaterialLoader;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SocialMaterialLoaderImpl
implements SocialMaterialLoader {
    private static final Logger log = LoggerFactory.getLogger(SocialMaterialLoaderImpl.class);
    @Resource
    private AccountMapper accountMapper;
    @Resource
    private StormSunWeChatQrCodeChatroomRelPoMapper qrCodeChatroomRelPoMapper;
    @Resource
    private ChatroomBoost chatroomBoost;
    @Value(value="${social.material.chatroom_qrcode_invalid_mills}")
    private long qrCodeInvalidLimit;
    @Value(value="${social.material.chatroom_source_accountids}")
    private String chatroomSrcAccountIds;
    @Value(value="${social.material.personal_qrcode_file_name}")
    private String personalQrcodeUrlFileName;
    @Value(value="${social.material.subscription_qrcode_file_name}")
    private String subscriptionQrcodeUrlFileName;
    private Gson gson = new Gson();

    @Override
    public SocialMaterialCache loadCache() throws Exception {
        Object[] accountIds = this.chatroomSrcAccountIds.split(",");
        log.info("load chatroom from accountids: {}", (Object)Arrays.toString(accountIds));
        ArrayList allChatroomList = new ArrayList();
        Object[] objectArray = accountIds;
        int n = accountIds.length;
        int n2 = 0;
        while (n2 < n) {
            Object accountId = objectArray[n2];
            allChatroomList.addAll(this.accountMapper.selectChatroomByAccountId(Integer.parseInt((String)accountId)));
            ++n2;
        }
        log.info("load all chatroom List: {}", (Object)((Object)allChatroomList).toString());
        if (allChatroomList.isEmpty()) {
            log.warn("no chatroom found in accounts: {}", (Object)this.chatroomSrcAccountIds);
            return SocialMaterialCache.buildEmptyCache();
        }
        ArrayList onWarrantyPeriodChatroomList = new ArrayList();
        this.chatroomBoost.queryChatroomMemberCount(allChatroomList).forEach((key, value) -> {
            if (value != null && value < 100) {
                onWarrantyPeriodChatroomList.add(key);
            }
        });
        log.info("qrcode on warranty period chatroom list: {}", (Object)((Object)onWarrantyPeriodChatroomList).toString());
        if (onWarrantyPeriodChatroomList.isEmpty()) {
            log.warn("no available chatroom found in accounts: {}", (Object)BizConf.gson.toJson((Object)accountIds));
            return SocialMaterialCache.buildEmptyCache();
        }
        ArrayList<String> availableChatroomQrcodeUrlList = new ArrayList<String>();
        List qrCodeChatroomRelList = this.qrCodeChatroomRelPoMapper.selectByChatroomList(onWarrantyPeriodChatroomList);
        for (StormSunWeChatQrCodeChatroomRelPo qrCodeChatroomRelPo : qrCodeChatroomRelList) {
            if (System.currentTimeMillis() - qrCodeChatroomRelPo.getUpdateTime().getTime() >= this.qrCodeInvalidLimit) continue;
            QrCodeChatroomRel qrCodeChatroomRel = (QrCodeChatroomRel)this.gson.fromJson(qrCodeChatroomRelPo.getRawContent(), QrCodeChatroomRel.class);
            availableChatroomQrcodeUrlList.add(qrCodeChatroomRel.getQrcodeUrl());
        }
        log.info("available chatroom qrcode url list: {}", (Object)((Object)availableChatroomQrcodeUrlList).toString());
        SocialMaterialCache socialMaterialCache = new SocialMaterialCache();
        socialMaterialCache.setChatroomQrcodeUrlList(availableChatroomQrcodeUrlList);
        socialMaterialCache.setPersonalQrcodeUrlList(this.loadQrcodeUrlListFromFile(this.personalQrcodeUrlFileName));
        socialMaterialCache.setSubscriptionQrcodeUrlList(this.loadQrcodeUrlListFromFile(this.subscriptionQrcodeUrlFileName));
        return socialMaterialCache;
    }

    private List<String> loadQrcodeUrlListFromFile(String fileName) {
        ArrayList<String> qrCodeList = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String lineString;
            URL path = this.getClass().getClassLoader().getResource(fileName);
            log.info("load qrcode file, path: {}", (Object)path.getPath());
            br = new BufferedReader(new FileReader(path.getPath()));
            while ((lineString = br.readLine()) != null) {
                qrCodeList.add(lineString.trim());
            }
            ArrayList<String> arrayList = qrCodeList;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            log.error("qrcode url file not exists {}", (Object)this.personalQrcodeUrlFileName, (Object)e);
            List<String> list = Collections.emptyList();
            return list;
        }
        catch (IOException e) {
            log.error("read qrcode url file failed", (Throwable)e);
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                log.error("close qrcode file failed", (Throwable)e);
            }
        }
    }
}

