/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.nursery;

import com.baijia.storm.sun.api.common.conf.BizConf;
import com.baijia.storm.sun.api.common.dto.request.SocialMaterialRequest;
import com.baijia.storm.sun.api.common.dto.response.SocialMaterialData;
import com.baijia.storm.sun.api.common.exception.BizException;
import com.baijia.storm.sun.nursery.social.cache.SocialMaterialCache;
import com.baijia.storm.sun.nursery.social.exception.ParamErrorException;
import com.baijia.storm.sun.nursery.social.loader.SocialMaterialLoader;
import com.baijia.storm.sun.nursery.social.strategy.AllocationStrategy;
import com.baijia.storm.sun.nursery.social.strategy.AllocationStrategyFactory;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SocialMaterialManager {
    private static final Logger log = LoggerFactory.getLogger(SocialMaterialManager.class);
    private SocialMaterialCache materialCache = null;
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private long updateTime = System.currentTimeMillis();
    @Value(value="${social.material.cache_expire_time}")
    private long cacheExpireTime;
    @Resource
    private SocialMaterialLoader socialMaterialLoader;
    private AllocationStrategy allocationStrategy = AllocationStrategyFactory.useStrategy("normal");

    public boolean rebuild(SocialMaterialCache newCache) {
        this.materialCache = newCache;
        return true;
    }

    private SocialMaterialCache getMaterialCache() {
        try {
            if (this.materialCache == null || this.cacheExpired()) {
                this.materialCache = this.socialMaterialLoader.loadCache();
                this.updateTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            log.error("load cache failed!", (Throwable)e);
        }
        return this.materialCache;
    }

    private boolean cacheExpired() {
        return this.updateTime + this.cacheExpireTime < System.currentTimeMillis();
    }

    public SocialMaterialData allocate(SocialMaterialRequest request) throws Exception {
        if (request == null || !request.isValid()) {
            log.info("social material request is not valid! request: {}", (Object)BizConf.gson.toJson((Object)request));
            throw new ParamErrorException("request is not legal");
        }
        SocialMaterialCache cache = this.getMaterialCache();
        if (cache == null || cache.isEmpty()) {
            log.info("social material request failed for cache is empty! request: {}", (Object)BizConf.gson.toJson((Object)request));
            throw new BizException();
        }
        return this.allocationStrategy.allocate(request, cache);
    }
}

