/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.dal.um.boost;

import com.baijia.storm.sun.dal.po.StormSunExclusivePo;
import com.baijia.storm.sun.dal.um.mapper.StormSunDevicePoMapper;
import com.baijia.storm.sun.dal.um.mapper.StormSunExclusivePoMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExclusiveBoost {
    private static final Logger log = LoggerFactory.getLogger(ExclusiveBoost.class);
    private static final Integer BASE_UNIT_NUM = 1000000;
    @Resource
    private StormSunExclusivePoMapper stormSunExclusivePoMapper;
    @Resource
    private StormSunDevicePoMapper devicePoMapper;

    public Integer toFansClusterUnit() {
        return BASE_UNIT_NUM;
    }

    public boolean isFansClusterRobot(Integer logicId) {
        List<Integer> fansClusterLogicIds = this.stormSunExclusivePoMapper.selectLogicIdsGTLimit(BASE_UNIT_NUM);
        return CollectionUtils.isNotEmpty(fansClusterLogicIds) && fansClusterLogicIds.contains(logicId);
    }

    public List<Integer> availableLogicIdsByUnit(Integer unit) {
        List<Integer> availableMasters = this.devicePoMapper.selectLogicIdByStatusAndSpecialized((byte)0, (byte)2);
        return this.stormSunExclusivePoMapper.selectLogicIdsByUnit(unit).stream().filter(availableMasters::contains).collect(Collectors.toList());
    }

    public List<Integer> allLogicIds() {
        return this.stormSunExclusivePoMapper.selectAllLogicIds();
    }

    public Map<Integer, List<Integer>> getUnit2LogicId() {
        List<StormSunExclusivePo> allExclusivePo = this.stormSunExclusivePoMapper.selectAll();
        HashMap<Integer, List<Integer>> unit2LogicId = new HashMap<Integer, List<Integer>>();
        allExclusivePo.forEach(po -> {
            Integer logicId = po.getLogicId();
            Integer unit = po.getUnit();
            this.group(unit2LogicId, unit, logicId);
        });
        return unit2LogicId;
    }

    private void group(Map<Integer, List<Integer>> map, Integer key, Integer value) {
        List<Integer> list = map.get(key);
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        list.add(value);
        map.put(key, list);
    }
}

