/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.dal.um.boost;

import com.baijia.storm.sun.api.common.enumeration.DeviceConstant;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.dal.um.mapper.StormSunDevicePoMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DeviceBoost {
    public static int DEVICE_AREA_BOUND = 90000;
    @Resource
    private StormSunDevicePoMapper stormSunDevicePoMapper;

    public List<StormSunDevicePo> availableX() {
        return this.availableDevices((byte)1);
    }

    public List<StormSunDevicePo> availableMaster() {
        return this.availableDevices((byte)2);
    }

    public List<StormSunDevicePo> availableIndividual() {
        return this.availableDevices((byte)4);
    }

    public List<StormSunDevicePo> availableSlave() {
        return this.availableDevices((byte)3);
    }

    private List<StormSunDevicePo> availableDevices(Byte specialized) {
        return this.stormSunDevicePoMapper.selectByStatusAndSpecialized((byte)0, specialized);
    }

    public List<StormSunDevicePo> availableDevices() {
        return this.stormSunDevicePoMapper.selectByStatusList(Collections.singletonList((byte)0));
    }

    public List<StormSunDevicePo> onlineDevices() {
        return this.stormSunDevicePoMapper.selectByStatusList(DeviceConstant.ONLINE_DEVICE_STATUS);
    }

    public StormSunDevicePo robotDeviceByUsername(String username) {
        StormSunDevicePo devicePo = this.stormSunDevicePoMapper.selectByUsername(username);
        if (devicePo != null && DeviceConstant.IS_VALID_ROBOT_STATUS.contains(devicePo.getStatus())) {
            return devicePo;
        }
        return null;
    }

    public List<StormSunDevicePo> robotDeviceByUsernames(Collection<String> usernameList) {
        return this.stormSunDevicePoMapper.selectByUsernameList(usernameList).stream().filter(d -> DeviceConstant.IS_VALID_ROBOT_STATUS.contains(d.getStatus())).collect(Collectors.toList());
    }

    public List<StormSunDevicePo> fullLoadDevices() {
        return this.stormSunDevicePoMapper.selectByStatusList(Collections.singletonList((byte)3));
    }

    public List<StormSunDevicePo> fullLoadDevicesExceptVirtual() {
        return this.fullLoadDevices().stream().filter(d -> d.getMachineIsVirtual() == 0).collect(Collectors.toList());
    }

    public List<StormSunDevicePo> getDevicesBjExceptVirtualBySpecialized(Byte specialized) {
        return this.onlineDevices().stream().filter(d -> d.getDeviceId() < DEVICE_AREA_BOUND && Objects.equals(d.getSpecialized(), specialized) && d.getMachineIsVirtual() == 0).collect(Collectors.toList());
    }

    public List<StormSunDevicePo> getDevicesWhExceptVirtualBySpecialized(Byte specialized) {
        return this.onlineDevices().stream().filter(d -> d.getDeviceId() >= DEVICE_AREA_BOUND && Objects.equals(d.getSpecialized(), specialized) && d.getMachineIsVirtual() == 0).collect(Collectors.toList());
    }

    public List<StormSunDevicePo> getOnlineDevicesByLogicIdList(List<Integer> logicIdList) {
        return this.onlineDevices().stream().filter(d -> logicIdList.contains(d.getLogicId())).collect(Collectors.toList());
    }
}

