/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.dal.um.boost;

import com.baijia.storm.sun.api.common.exception.ResourceNotEnoughException;
import com.baijia.storm.sun.api.common.util.ListUtil;
import com.baijia.storm.sun.dal.po.StormSunChatroomPoolPo;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.dal.um.boost.ExclusiveBoost;
import com.baijia.storm.sun.dal.um.mapper.StormSunChatroomPoolPoMapper;
import com.baijia.storm.sun.dal.um.mapper.StormSunDevicePoMapper;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ChatroomPoolBoost {
    private static final Logger log = LoggerFactory.getLogger(ChatroomPoolBoost.class);
    @Resource
    private StormSunDevicePoMapper stormSunDevicePoMapper;
    @Resource
    private StormSunChatroomPoolPoMapper stormSunChatroomPoolPoMapper;
    @Resource
    private ExclusiveBoost exclusiveBoost;

    public StormSunChatroomPoolPo selectOne(int unit, boolean fansCluster) throws ResourceNotEnoughException {
        List<Integer> exclusiveMasters;
        if (fansCluster) {
            unit = this.exclusiveBoost.toFansClusterUnit();
        }
        if (CollectionUtils.isEmpty(exclusiveMasters = this.exclusiveBoost.availableLogicIdsByUnit(unit))) {
            if (fansCluster) {
                throw new ResourceNotEnoughException("No exclusivFe fans cluster for this unit.");
            }
            List<Integer> allExclusiveLogicIds = this.exclusiveBoost.allLogicIds();
            exclusiveMasters = this.stormSunDevicePoMapper.selectAvailableNotIn((byte)2, allExclusiveLogicIds).stream().map(StormSunDevicePo::getLogicId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(exclusiveMasters)) {
            throw new ResourceNotEnoughException();
        }
        StormSunChatroomPoolPo result = this.selectOne(exclusiveMasters);
        log.info("Chatroom pool fansCluster [{}], unit [{}], result chatroom [{}]", new Object[]{fansCluster, unit, result.getChatroom()});
        return result;
    }

    @Transactional(value="umTransactionManager")
    public StormSunChatroomPoolPo selectOne(List<Integer> availableMasterLogicIdList) throws ResourceNotEnoughException {
        List<StormSunChatroomPoolPo> chatroomPoolPoList = this.stormSunChatroomPoolPoMapper.selectByStatusAndLogicIdsAndTimeForUpdate((byte)0, availableMasterLogicIdList, DateUtils.addMinutes((Date)new Date(), (int)-5));
        if (CollectionUtils.isEmpty(chatroomPoolPoList)) {
            throw new ResourceNotEnoughException();
        }
        StormSunChatroomPoolPo win = (StormSunChatroomPoolPo)ListUtil.getRandom(chatroomPoolPoList);
        this.stormSunChatroomPoolPoMapper.updateStatusById(win.getId(), (byte)1);
        return win;
    }
}

