/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.dal.um.boost;

import com.baijia.storm.lib.model.WeChatroom;
import com.baijia.storm.sun.api.common.proto.QueryCondition;
import com.baijia.storm.sun.dal.condition.ChatroomQuery;
import com.baijia.storm.sun.dal.po.StormSunChatroomModificationPo;
import com.baijia.storm.sun.dal.po.StormSunChatroomPo;
import com.baijia.storm.sun.dal.po.StormSunDevicePo;
import com.baijia.storm.sun.dal.um.boost.DeviceBoost;
import com.baijia.storm.sun.dal.um.mapper.StormSunChatroomModificationPoMapper;
import com.baijia.storm.sun.dal.um.mapper.StormSunChatroomPoMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ChatroomBoost {
    @Resource
    private StormSunChatroomPoMapper chatroomPoMapper;
    @Resource
    private StormSunChatroomModificationPoMapper modificationPoMapper;
    @Resource
    private DeviceBoost deviceBoost;

    public StormSunChatroomPo queryChatroomPo(String chatroom) {
        return this.chatroomPoMapper.selectByChatroom(chatroom);
    }

    public StormSunChatroomPo queryChatroomBasicInfo(String chatroom) {
        return this.chatroomPoMapper.selectBasicByChatroom(chatroom);
    }

    public WeChatroom queryChatroom(String chatroomname) {
        StormSunChatroomPo po = this.chatroomPoMapper.selectByChatroom(chatroomname);
        if (po == null) {
            return null;
        }
        return po.genWeChatroom();
    }

    public List<WeChatroom> queryChatroom(List<String> chatrooms) {
        return this.chatroomPoMapper.selectByChatroomList(chatrooms).stream().map(StormSunChatroomPo::genWeChatroom).collect(Collectors.toList());
    }

    public ChatroomQuery genChatroomQuery(String key, Integer pageNo, Integer pageSize) {
        ChatroomQuery query = new ChatroomQuery();
        query.setKeyword(key);
        if (pageNo != null && pageNo > 0 && pageSize != null && pageSize > 0) {
            query.setStart(Long.valueOf(pageSize.intValue()) * (long)(pageNo - 1));
            query.setLimit(pageSize);
        }
        return query;
    }

    public ChatroomQuery genChatroomQuery(List<String> chatroomList, QueryCondition qc) {
        ChatroomQuery query = new ChatroomQuery(chatroomList);
        if (qc != null) {
            query.setKeyword(qc.getTerm());
            if (qc.getPrivileged() != null) {
                query.setIsRobotOwner(qc.getPrivileged());
                List<String> robotList = this.deviceBoost.onlineDevices().stream().map(StormSunDevicePo::getWechatUsername).collect(Collectors.toList());
                query.setRobotList(robotList);
            }
            Integer pageNo = qc.getPageNo();
            Integer pageSize = qc.getPageSize();
            if (pageNo != null && pageNo > 0 && pageSize != null && pageSize > 0) {
                query.setStart(Long.valueOf(pageSize.intValue()) * (long)(pageNo - 1));
                query.setLimit(pageSize);
            }
        }
        return query;
    }

    public List<WeChatroom> queryChatroom(ChatroomQuery chatroomQuery) {
        return this.convertFromBasic(this.chatroomPoMapper.selectBasicByFilterPaging(chatroomQuery));
    }

    public Integer queryChatroomCount(ChatroomQuery chatroomQuery) {
        return this.chatroomPoMapper.selectBasicCountByFilter(chatroomQuery);
    }

    public Map<String, Integer> queryChatroomMemberCount(List<String> chatroomList) {
        return this.chatroomPoMapper.selectMemberCountByChatroomList(chatroomList).stream().collect(Collectors.toMap(StormSunChatroomPo::getChatroom, StormSunChatroomPo::getMemberCount));
    }

    public Map<String, List<String>> queryMembersMap(Collection<String> chatroomList) {
        return this.chatroomPoMapper.selectExtByChatroomList(chatroomList).stream().collect(Collectors.toMap(StormSunChatroomPo::getChatroom, StormSunChatroomPo::getMemberUsernames));
    }

    private List<WeChatroom> convertFromBasic(List<StormSunChatroomPo> basicPos) {
        if (CollectionUtils.isEmpty(basicPos)) {
            return Collections.emptyList();
        }
        List<String> chatrooms = basicPos.stream().map(StormSunChatroomPo::getChatroom).collect(Collectors.toList());
        Map chatroom2Ext = this.chatroomPoMapper.selectExtByChatroomList(chatrooms).stream().collect(Collectors.toMap(StormSunChatroomPo::getChatroom, Function.identity()));
        return basicPos.stream().map(b -> {
            WeChatroom wc = b.genWeChatroomFromBasic();
            StormSunChatroomPo extPo = (StormSunChatroomPo)chatroom2Ext.get(wc.getChatroomName());
            wc.setMemberUsernameList(extPo.getMemberUsernames());
            wc.setChatroomNotice(extPo.getNotice());
            return wc;
        }).collect(Collectors.toList());
    }

    public List<WeChatroom> queryChatroom(Date updateTime, long start, int limit) {
        return this.convertFromBasic(this.chatroomPoMapper.selectBasicByUpdateTimePaging(updateTime, start, limit));
    }

    @Transactional(value="umTransactionManager")
    public void updateChatroom(List<StormSunChatroomPo> pos) {
        pos.forEach(po -> {
            if (StringUtils.isEmpty((CharSequence)po.getNickname())) {
                StormSunChatroomPo chatroomPo = this.chatroomPoMapper.selectBasicByChatroom(po.getChatroom());
                if (chatroomPo != null && StringUtils.isNotEmpty((CharSequence)chatroomPo.getNickname())) {
                    return;
                }
                po.setNickname("");
            }
            if (this.chatroomPoMapper.updateBasicByChatroomname((StormSunChatroomPo)po) <= 0) {
                this.chatroomPoMapper.insertBasic((StormSunChatroomPo)po);
            }
            if (this.chatroomPoMapper.updateExtByChatroomname((StormSunChatroomPo)po) <= 0) {
                this.chatroomPoMapper.insertExt((StormSunChatroomPo)po);
            }
            this.modificationPoMapper.insertIgnore(this.genModificationPo((StormSunChatroomPo)po));
        });
    }

    private StormSunChatroomModificationPo genModificationPo(StormSunChatroomPo sunChatroomPo) {
        StormSunChatroomModificationPo po = new StormSunChatroomModificationPo();
        po.setChatroom(sunChatroomPo.getChatroom());
        po.setNowNickname(sunChatroomPo.getNickname());
        po.setNicknameOpUsername("");
        po.setNicknameOpNickname("");
        po.setOldNickname("");
        return po;
    }
}

