/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.dal.um.boost;

import com.baijia.storm.sun.api.common.util.QueueKeyGenerator;
import com.baijia.storm.sun.dal.po.StormSunAllocationPo;
import com.baijia.storm.sun.dal.um.mapper.StormSunAllocationPoMapper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AllocationBoost {
    @Resource
    private StormSunAllocationPoMapper mapper;

    public boolean isMasterInChatroom(int logicId, String chatroom) {
        return this.isSMInChatroom(logicId, chatroom, true);
    }

    public boolean isSlaveInChatroom(int logicId, String chatroom) {
        return this.isSMInChatroom(logicId, chatroom, false);
    }

    private boolean isSMInChatroom(int logicId, String chatroom, boolean isMaster) {
        List<StormSunAllocationPo> allocationPoList = this.mapper.selectByQueueKey(QueueKeyGenerator.genChatroomQueueKey((String)chatroom, (boolean)isMaster));
        if (CollectionUtils.isEmpty(allocationPoList)) {
            return false;
        }
        for (StormSunAllocationPo allocationPo : allocationPoList) {
            if (allocationPo.getLogicId() != logicId) continue;
            return true;
        }
        return false;
    }

    public List<StormSunAllocationPo> queryManagedAllocationByChatroomList(Collection<String> chatroomList) {
        LinkedList<String> queueKeyList = new LinkedList<String>();
        for (String chatroom : chatroomList) {
            queueKeyList.addAll(QueueKeyGenerator.genChatroomQueueKeyAll((String)chatroom));
        }
        return this.mapper.selectByQueueKeyListAndStatus(queueKeyList, (byte)1);
    }

    public Integer queryMasterLogicId(String chatroom) {
        List<StormSunAllocationPo> allocationPos = this.mapper.selectByQueueKeyAndStatus(QueueKeyGenerator.genChatroomQueueKey((String)chatroom, (boolean)true), (byte)1);
        if (CollectionUtils.isEmpty(allocationPos)) {
            return null;
        }
        return allocationPos.get(allocationPos.size() - 1).getLogicId();
    }

    public Integer querySlaveLogicId(String chatroom) {
        List<StormSunAllocationPo> allocationPos = this.mapper.selectByQueueKeyAndStatus(QueueKeyGenerator.genChatroomQueueKey((String)chatroom, (boolean)false), (byte)1);
        if (CollectionUtils.isEmpty(allocationPos)) {
            return null;
        }
        return allocationPos.get(allocationPos.size() - 1).getLogicId();
    }
}

