/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.sun.dal.po;

import com.baijia.storm.lib.model.WeChatroom;
import com.baijia.storm.sun.api.common.conf.BizConf;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StormSunChatroomPo {
    private Long id;
    private String chatroom;
    private String nickname;
    private String roomOwner;
    private Integer memberCount;
    private Date createTime;
    private Date updateTime;
    private String memberList;
    private String notice;

    public StormSunChatroomPo() {
    }

    public StormSunChatroomPo(String chatroom, String nickname, String roomOwner, Integer memberCount) {
        this.chatroom = chatroom;
        this.nickname = nickname;
        this.roomOwner = roomOwner;
        this.memberCount = memberCount;
    }

    public StormSunChatroomPo(String chatroom, String memberList, String notice) {
        this.chatroom = chatroom;
        this.memberList = memberList;
        this.notice = notice;
    }

    public StormSunChatroomPo(WeChatroom chatroom) {
        this.chatroom = chatroom.getChatroomName();
        this.nickname = chatroom.getChatroomNickname();
        this.roomOwner = chatroom.getRoomowner();
        List memberList = chatroom.getMemberUsernameList();
        if (memberList == null) {
            memberList = Collections.emptyList();
        }
        this.memberCount = memberList.size();
        this.memberList = BizConf.gson.toJson(memberList);
        this.notice = chatroom.getChatroomNotice();
    }

    public WeChatroom genWeChatroomFromBasic() {
        return new WeChatroom(this.chatroom, this.roomOwner, this.nickname, null, null, null);
    }

    public WeChatroom genWeChatroom() {
        return new WeChatroom(this.chatroom, this.roomOwner, this.nickname, (List)BizConf.gson.fromJson(this.memberList, TypeToken.get(List.class).getType()), this.notice, null);
    }

    public List<String> getMemberUsernames() {
        if (StringUtils.isNotEmpty((CharSequence)this.memberList)) {
            return (List)BizConf.gson.fromJson(this.memberList, TypeToken.get(List.class).getType());
        }
        return Collections.emptyList();
    }

    public Long getId() {
        return this.id;
    }

    public String getChatroom() {
        return this.chatroom;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getRoomOwner() {
        return this.roomOwner;
    }

    public Integer getMemberCount() {
        return this.memberCount;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getMemberList() {
        return this.memberList;
    }

    public String getNotice() {
        return this.notice;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setChatroom(String chatroom) {
        this.chatroom = chatroom;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setRoomOwner(String roomOwner) {
        this.roomOwner = roomOwner;
    }

    public void setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setMemberList(String memberList) {
        this.memberList = memberList;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StormSunChatroomPo)) {
            return false;
        }
        StormSunChatroomPo other = (StormSunChatroomPo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$chatroom = this.getChatroom();
        String other$chatroom = other.getChatroom();
        if (this$chatroom == null ? other$chatroom != null : !this$chatroom.equals(other$chatroom)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$roomOwner = this.getRoomOwner();
        String other$roomOwner = other.getRoomOwner();
        if (this$roomOwner == null ? other$roomOwner != null : !this$roomOwner.equals(other$roomOwner)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$memberList = this.getMemberList();
        String other$memberList = other.getMemberList();
        if (this$memberList == null ? other$memberList != null : !this$memberList.equals(other$memberList)) {
            return false;
        }
        String this$notice = this.getNotice();
        String other$notice = other.getNotice();
        return !(this$notice == null ? other$notice != null : !this$notice.equals(other$notice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StormSunChatroomPo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $chatroom = this.getChatroom();
        result = result * 59 + ($chatroom == null ? 43 : $chatroom.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $roomOwner = this.getRoomOwner();
        result = result * 59 + ($roomOwner == null ? 43 : $roomOwner.hashCode());
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $memberList = this.getMemberList();
        result = result * 59 + ($memberList == null ? 43 : $memberList.hashCode());
        String $notice = this.getNotice();
        result = result * 59 + ($notice == null ? 43 : $notice.hashCode());
        return result;
    }

    public String toString() {
        return "StormSunChatroomPo(id=" + this.getId() + ", chatroom=" + this.getChatroom() + ", nickname=" + this.getNickname() + ", roomOwner=" + this.getRoomOwner() + ", memberCount=" + this.getMemberCount() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", memberList=" + this.getMemberList() + ", notice=" + this.getNotice() + ")";
    }
}

