/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.util;

import com.baijia.storm.lib.util.Log;
import com.baijia.storm.lib.util.NumberUtils;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Random;

public class StringUtils {
    private static final Integer NORMAL_LENGTH = 15000;
    private static final Random RANDOM = new Random();
    public static final String EMPTY = "";

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isEmpty(String ... param) {
        return param == null || param.length == 0;
    }

    public static boolean isNotEmpty(String ... param) {
        return !StringUtils.isEmpty(param);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static String getFileSuffix(String filePath) {
        int idx = filePath.lastIndexOf(".");
        String suffix = null;
        if (idx != -1) {
            suffix = filePath.substring(idx);
        }
        return suffix;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (cs != null && !StringUtils.isEmpty(cs)) {
            int sz = cs.length();
            for (int i = 0; i < sz; ++i) {
                if (Character.isLowerCase(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (cs != null && !StringUtils.isEmpty(cs)) {
            int sz = cs.length();
            for (int i = 0; i < sz; ++i) {
                if (Character.isUpperCase(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isChatroomName(String chatroom) {
        int idx;
        if (StringUtils.isNotEmpty((CharSequence)chatroom) && (idx = chatroom.indexOf("@")) != -1) {
            return NumberUtils.isDigits(chatroom.substring(0, idx)) && "@chatroom".equals(chatroom.substring(idx));
        }
        return false;
    }

    public static boolean isNotChatroomName(String chatroom) {
        return !StringUtils.isChatroomName(chatroom);
    }

    public static String getMD5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (Exception e) {
            return EMPTY;
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String getVoiceFileName(String path) {
        if (StringUtils.isBlank(path)) {
            return EMPTY;
        }
        String[] array = path.split("/");
        String wholeName = array[array.length - 1];
        int beginIdx = wholeName.indexOf("_") + 1;
        int endIdx = wholeName.indexOf(".");
        return wholeName.substring(beginIdx, endIdx);
    }

    public static Integer getVoiceLength(String sourcePath) {
        if (StringUtils.isEmpty((CharSequence)sourcePath)) {
            return NORMAL_LENGTH;
        }
        try {
            int startIdx = sourcePath.lastIndexOf("_") + 1;
            int endIdx = sourcePath.lastIndexOf(".amr");
            if (startIdx != -1 && endIdx != -1) {
                return Integer.valueOf(sourcePath.substring(startIdx, endIdx));
            }
        }
        catch (Exception e) {
            Log.error("get voice length", e);
        }
        return NORMAL_LENGTH;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        return StringUtils.regionMatches(cs1, false, 0, cs2, 0, Math.max(cs1.length(), cs2.length()));
    }

    private static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static String trimAllWithoutSpace(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return EMPTY;
        }
        char[] value = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char aValue : value) {
            if (aValue == '\t' || aValue == '\n') continue;
            sb.append(aValue);
        }
        return sb.toString();
    }

    public static String getFileName(String fullPath) {
        if (StringUtils.isEmpty((CharSequence)fullPath)) {
            return null;
        }
        String[] array = fullPath.split("/");
        String fileName = array[array.length - 1];
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        return fileName;
    }

    public static String getRandomStr() {
        String poolStr = "abcdefghijklmnopqrstuvwxyz0123456789";
        return StringUtils.random(6, poolStr.toCharArray());
    }

    public static String random(int count, char ... chars) {
        if (chars == null) {
            return StringUtils.random(count, 0, 0, false, false, null, RANDOM);
        }
        return StringUtils.random(count, 0, chars.length, false, false, chars, RANDOM);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return EMPTY;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (chars != null && chars.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (start == 0 && end == 0) {
            if (chars != null) {
                end = chars.length;
            } else if (!letters && !numbers) {
                end = Integer.MAX_VALUE;
            } else {
                end = 123;
                start = 32;
            }
        } else if (end <= start) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater than start (" + start + ")");
        }
        char[] buffer = new char[count];
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = (char)(56320 + random.nextInt(128));
                    buffer[--count] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                    continue;
                }
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    public static String getStickerMd5(String content) {
        return StringUtils.subString(content, "<emoticonmd5>", "</emoticonmd5>");
    }

    public static String getMD5InImageMsg(String content) {
        String result = null;
        int idx = content.indexOf("md5=\"");
        if (idx != -1) {
            String subStr = content.substring(idx + 5);
            int endIdx = subStr.indexOf("\"");
            result = subStr.substring(0, endIdx);
        }
        return result;
    }

    public static String getChatrooomId(String chatroom) {
        if (StringUtils.isEmpty((CharSequence)chatroom)) {
            return EMPTY;
        }
        int endIdx = chatroom.indexOf("@chatroom");
        if (endIdx != -1) {
            return chatroom.substring(0, endIdx);
        }
        return chatroom;
    }

    public static String getMsgXML(String content) {
        int beginIdx = content.indexOf("<msg>");
        int endIdx = content.lastIndexOf("/msg>");
        String xml = EMPTY;
        if (beginIdx != -1 && endIdx != -1) {
            xml = content.substring(beginIdx, endIdx + 5);
        }
        return xml;
    }

    public static String getStickerUrl(String content) {
        String result = StringUtils.subString(content, "cdnurl=\"", "\"").replace("*#*", ":");
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = StringUtils.subString(content, "cdnurl = \"", "\"").replace("*#*", ":");
        }
        return result;
    }

    public static String getStickerProductId(String content) {
        return StringUtils.subString(content, "productid=\"", "\"");
    }

    public static String getUsernameInContactCard(String content) {
        return StringUtils.subString(content, "username=\"", "\"");
    }

    public static boolean isOfficalAccount(String cardContent) {
        String certFlag = StringUtils.subString(cardContent, "certflag=\"", "\"");
        return NumberUtils.isNumber(certFlag) && Integer.valueOf(certFlag) > 0;
    }

    public static String subString(String originalStr, String beginStr, String endStr) {
        int beginIdx;
        if (StringUtils.isNotBlank(originalStr) && StringUtils.isNotEmpty((CharSequence)beginStr) && StringUtils.isNotEmpty((CharSequence)endStr) && (beginIdx = originalStr.indexOf(beginStr)) != -1) {
            String tmp = originalStr.substring(beginIdx + beginStr.length());
            int endIdx = tmp.indexOf(endStr);
            return tmp.substring(0, endIdx);
        }
        return EMPTY;
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            String result = StringUtils.toString(first);
            return result;
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String getEncoding(String str) {
        String encode = "GB2312";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s = encode;
                return s;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        encode = "ISO-8859-1";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s1 = encode;
                return s1;
            }
        }
        catch (Exception s1) {
            // empty catch block
        }
        encode = "UTF-8";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s2 = encode;
                return s2;
            }
        }
        catch (Exception s2) {
            // empty catch block
        }
        encode = "GBK";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s3 = encode;
                return s3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EMPTY;
    }

    public static String toString(Object obj) {
        return obj == null ? EMPTY : obj.toString();
    }
}

