/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.util;

import com.baijia.storm.lib.util.StringUtils;
import com.baijia.storm.lib.util.TimeUtil;
import java.util.Arrays;

public class Log {
    static String appKey = "";
    private static final String ERROR_PREFIX = " ERROR ";
    private static final String WARN_PREFIX = " WARN ";
    private static final String INFO_PREFIX = " INFO ";
    private static final String DEBUG_PREFIX = " DEBUG ";
    public static boolean isDebugEnabled = false;
    private static Long debugExpiredTime = 0L;

    public static void setDebugEnabled() {
        isDebugEnabled = true;
        debugExpiredTime = TimeUtil.currentTimeMills() + 300000L;
    }

    public static void setDebugEnabled4TestEnv() {
        isDebugEnabled = true;
        debugExpiredTime = TimeUtil.currentTimeMills() + 432000000L;
    }

    private static boolean expired() {
        boolean expired;
        boolean bl = expired = TimeUtil.currentTimeMills() > debugExpiredTime;
        if (expired) {
            isDebugEnabled = false;
        }
        return expired;
    }

    public static void setDebugDisabled() {
        isDebugEnabled = false;
    }

    public static void debug(Object obj) {
        if (obj == null) {
            System.out.printf("%s %s %s\n", DEBUG_PREFIX, appKey, obj);
        } else {
            System.out.printf("%s %s %s\n", DEBUG_PREFIX, appKey, obj.toString().replaceAll("\n", "\t"));
        }
    }

    public static void warn(Object obj) {
        System.out.printf("%s %s %s\n", WARN_PREFIX, appKey, obj);
    }

    public static void error(String desc, Throwable th) {
        Log.error(ERROR_PREFIX, "[" + desc + "] " + th + " StackTrace: " + Arrays.toString(th.getStackTrace()));
    }

    public static void error(Object obj) {
        System.out.printf("%s %s %s\n", ERROR_PREFIX, appKey, obj);
    }

    public static void error(String symbol, Object obj) {
        System.out.printf("%s %s %s\n", ERROR_PREFIX, appKey, obj);
    }

    private static boolean needSendMsg(Throwable th) {
        return !StringUtils.isBlank(th.getMessage()) && !th.getMessage().contains("java.net.UnknownHostException") && !th.getMessage().contains("Expected BEGIN_OBJECT");
    }

    public static void info(Object obj) {
        System.out.printf("%s %s %s", INFO_PREFIX, appKey, obj);
    }

    private String getAppKey() {
        return appKey;
    }

    public static void setAppKey(String appKeyParam) {
        appKey = appKeyParam;
    }
}

