/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.util;

import com.baijia.storm.lib.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;

public class FileUtil {
    public static boolean copy(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] bArr = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(bArr);
            bufferedInputStream.close();
            if (!file2.exists() && !file2.createNewFile()) {
                System.out.println("zhuandiqiu create file when copy files");
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            bufferedOutputStream.write(bArr);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("zhuandiqiu Copy file " + e.toString());
            return false;
        }
    }

    public static String getMd5(String filePath) {
        File file = new File(filePath);
        return FileUtil.getMd5(file);
    }

    public static String getMd5(File file) {
        String value = null;
        try (FileInputStream in = new FileInputStream(file);){
            MappedByteBuffer byteBuffer = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(byteBuffer);
            BigInteger bi = new BigInteger(1, md5.digest());
            value = bi.toString(16);
        }
        catch (Exception e) {
            Log.error("Error while get MD5 of a file :" + e.toString());
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLine(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            StringBuilder sb = new StringBuilder("");
            br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            if (line != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            Log.error(" FileInfo [load file content exception: file not found] " + e.toString());
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error(" [load file content exception: io error]" + e.toString());
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Log.error("[load file content exception: when close file reader]" + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFileContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder("");
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            Log.error(" FileInfo [load file content exception: file not found] " + e.toString());
            String string = null;
            return string;
        }
        catch (IOException e) {
            Log.error(" [load file content exception: io error]" + e.toString());
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Log.error("[load file content exception: when close file reader]" + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendToFile(File file, String content) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (content == null) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, true));
            bw.write(content);
            bw.newLine();
            bw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.error(" [append file content exception: io exception]" + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    Log.error("[append file content exception: when close bufferedwriter]" + e.toString());
                }
            }
        }
    }
}

