/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.util;

import com.baijia.storm.lib.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class FileManager {
    private static FileManager instance = new FileManager();
    private ExecutorService fixedThreadPool = Executors.newFixedThreadPool(6);
    private static final OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(7L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();

    public static FileManager instance() {
        return instance;
    }

    private FileManager() {
    }

    public String downLoadFile(String originPath, String desDir) throws IOException {
        Request request = new Request.Builder().url(originPath).build();
        Response response = okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            File file = this.createFile(StringUtils.getFileName(originPath), desDir);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            InputStream inputStream = response.body().byteStream();
            this.readInputStream(inputStream, fileOutputStream);
            inputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
            return file.getAbsolutePath();
        }
        if (response.code() == 404) {
            throw new FileNotFoundException();
        }
        throw new IOException("Unexpected code " + response);
    }

    private File createFile(String fileName, String desDir) throws IOException {
        File file = new File(desDir, fileName);
        File dir = new File(desDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new FileNotFoundException("create file failed");
        }
        return file;
    }

    private void readInputStream(InputStream inputStream, FileOutputStream fileOutputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            fileOutputStream.write(buffer, 0, len);
        }
    }
}

