/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.util;

import com.baijia.storm.lib.model.LinkMsgStuff;
import com.baijia.storm.lib.util.TextUtils;
import com.baijia.storm.lib.util.XmlUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CardUtils {
    public static final Map<Integer, String> ALL_MSG_CARD_TYPES = new HashMap<Integer, String>(){
        {
            this.put(3, "\u97f3\u4e50");
            this.put(5, "\u94fe\u63a5");
            this.put(6, "\u6587\u4ef6");
            this.put(19, "\u804a\u5929\u8bb0\u5f55");
            this.put(24, "\u8bed\u97f3\u8bb0\u5f55");
            this.put(33, "\u5c0f\u7a0b\u5e8f");
        }
    };

    public static boolean isValidMsgCardXML(String xmlContent) {
        if (StringUtils.isEmpty((CharSequence)xmlContent)) {
            return false;
        }
        return xmlContent.contains("<msg>") && xmlContent.contains("<appmsg appid=") && xmlContent.contains("<title>") && xmlContent.contains("</title>") && xmlContent.contains("</appmsg>") && xmlContent.contains("</msg>") && (xmlContent.contains("<type>5</type>") || xmlContent.contains("<type>3</type>") || xmlContent.contains("<type>6</type>"));
    }

    public static boolean isLinkCardXML(String xmlContent) {
        return xmlContent.contains("<type>5</type>") && CardUtils.isValidMsgCardXML(xmlContent);
    }

    public static boolean isFileCardXML(String xmlContent) {
        return xmlContent.contains("<type>6</type>") && CardUtils.isValidMsgCardXML(xmlContent);
    }

    public static boolean isMusicCardXML(String xmlContent) {
        return xmlContent.contains("<type>3</type>") && CardUtils.isValidMsgCardXML(xmlContent);
    }

    public static boolean isValidOfficalCardXML(String xmlContent) {
        if (!(!StringUtils.isEmpty((CharSequence)xmlContent) && xmlContent.contains("<msg bigheadimgurl=\"") && xmlContent.contains("username=\"") && xmlContent.contains("nickname=\"") && xmlContent.contains("certflag=\"") && xmlContent.contains("certinfo=\""))) {
            return false;
        }
        String certFlag = TextUtils.subString(xmlContent, "certflag=\"", "\"");
        return NumberUtils.isNumber((String)certFlag) && Integer.valueOf(certFlag) > 0;
    }

    public static String msgCardOutline(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        Integer type = CardUtils.getMsgCardType(content);
        String typeDesc = ALL_MSG_CARD_TYPES.get(type);
        if (StringUtils.isEmpty((CharSequence)typeDesc)) {
            typeDesc = "\u672a\u77e5";
        }
        String title = CardUtils.getMsgCardTitle(content);
        String desc = CardUtils.getMsgCardDesc(content);
        String appname = CardUtils.getMsgCardAppname(content);
        String result = "MsgCard: type[" + typeDesc + "]; title[" + title + "]; desc[" + desc + "]";
        if (StringUtils.isNotEmpty((CharSequence)appname)) {
            result = result + "; appname[" + appname + "]";
        }
        return result;
    }

    public static String officalCardOutline(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        String nickname = CardUtils.getOfficalCardNickname(content);
        return "OfficalCard: nickname[" + nickname + "]";
    }

    public static void main(String[] args) {
        System.out.println(CardUtils.officalCardOutline("<?xml version=\"1.0\"?>\n<msg bigheadimgurl=\"http://wx.qlogo.cn/mmhead/Q3auHgzwzM65WnRNFRF7ac9AiaBHrOrq6GuaqW0JjxuMEicTFGguwQhg/0\" smallheadimgurl=\"http://wx.qlogo.cn/mmhead/Q3auHgzwzM65WnRNFRF7ac9AiaBHrOrq6GuaqW0JjxuMEicTFGguwQhg/96\" username=\"gh_e7a23c829463\" nickname=\"\u767e\u5ea6\" fullpy=\"baidu\" shortpy=\"\" alias=\"baidu_2000\" imagestatus=\"4\" scene=\"17\" province=\"\u5317\u4eac\" city=\"\u4e2d\u56fd\" sign=\"\" sex=\"0\" certflag=\"24\" certinfo=\"\u767e\u5ea6\u5728\u7ebf\u7f51\u7edc\u6280\u672f(\u5317\u4eac)\u6709\u9650\u516c\u53f8\" brandIconUrl=\"http://mmbiz.qpic.cn/mmbiz_png/0VQlwOsFb0kG7uGXaa9jZHwEcRsYmvdu93icdpWXHCEXIbtg7uJ2cdD8QaFUZAc3o8Zoydg81yW1TYYPP5I2fQw/0?wx_fmt=png\" brandHomeUrl=\"\" brandSubscriptConfigUrl=\"{&quot;urls&quot;:[{&quot;title&quot;:&quot;\u67e5\u770b\u5386\u53f2\u6d88\u606f&quot;,&quot;url&quot;:&quot;http:\\/\\/mp.weixin.qq.com\\/mp\\/getmasssendmsg?__biz=MjM5NzU2OTgyMg==#wechat_webview_type=1&amp;wechat_redirect&quot;,&quot;title_key&quot;:&quot;__mp_wording__brandinfo_history_massmsg&quot;}]}\" brandFlags=\"2\" regionCode=\"CN_Beijing_Haidian\" />"));
        System.out.println(CardUtils.msgCardOutline("<msg><appmsg appid=\"wx5aa333606550dfd5\" sdkver=\"0\"><title>\u6325\u7740\u7fc5\u8180\u7684\u5973\u5b69 </title><des>\u5bb9\u7956\u513f</des><action></action><type>3</type><showtype>0</showtype><soundtype>0</soundtype><mediatagname></mediatagname><messageext></messageext><messageaction></messageaction><content></content><contentattr>0</contentattr><url>https://i.y.qq.com/v8/playsong.html?hostuin=1083935349&amp;sharefrom=&amp;f\u2026)&amp;_wv=1&amp;source=qq&amp;appshare=iphone&amp;media_mid=000Y4byc1P2fL7</url><lowurl>https://i.y.qq.com/v8/playsong.html?hostuin=1083935349&amp;sharefrom=&amp;f\u2026)&amp;_wv=1&amp;source=qq&amp;appshare=iphone&amp;media_mid=000Y4byc1P2fL7</lowurl><dataurl>http://i.y.qq.com/rsc/fcgi-bin/fcg_pyq_play.fcg?songid=0&amp;songmid=000Y4byc1P2fL7&amp;songtype=1&amp;fromtag=46&amp;uin=1083935349&amp;code=faf5f</dataurl><lowdataurl>http://i.y.qq.com/rsc/fcgi-bin/fcg_pyq_play.fcg?songid=0&amp;songmid=000Y4byc1P2fL7&amp;songtype=1&amp;fromtag=46&amp;uin=1083935349&amp;code=faf5f</lowdataurl><appattach><totallen>0</totallen><attachid></attachid><emoticonmd5></emoticonmd5><fileext></fileext><cdnthumburl>304d0201000446304402010002041238d91302033d390d02047911a3b4020458f4a01b0422777869645f7030696b33617a70387270363231313834345f313439323432363737390201000201000400</cdnthumburl><cdnthumbmd5>2b7ca28acda678bfffbb35a11fcadc8e</cdnthumbmd5><cdnthumblength>9650</cdnthumblength><cdnthumbwidth>150</cdnthumbwidth><cdnthumbheight>150</cdnthumbheight><cdnthumbaeskey>737303c8b1d44a4893bca248e00f2607</cdnthumbaeskey><aeskey>737303c8b1d44a4893bca248e00f2607</aeskey><encryver>0</encryver></appattach><extinfo></extinfo><sourceusername></sourceusername><sourcedisplayname></sourcedisplayname><thumburl></thumburl><md5></md5><statextstr>GhQKEnd4NWFhMzMzNjA2NTUwZGZkNQ==</statextstr></appmsg><fromusername>rareyang</fromusername><scene>0</scene><appinfo><version>48</version><appname>QQ\u97f3\u4e50</appname></appinfo><commenturl></commenturl></msg>"));
        System.out.println(CardUtils.msgCardOutline("<msg><appmsg appid=\"\" sdkver=\"0\"><title></title><des>E e F f G g\u8ddf\u8bfb [\u8bed\u97f3]3&quot; [\u8bed\u97f3]4&quot; [\u8bed\u97f3]3&quot;...</des><username></username><action>view</action><type>24</type><showtype>0</showtype><content></content><url>https://support.weixin.qq.com/cgi-bin/mmsupport-bin/readtemplate?t=page/common_page__upgrade&amp;btn_text=btn_text_0&amp;text=text008</url><lowurl></lowurl><dataurl></dataurl><lowdataurl></lowdataurl><contentattr>0</contentattr><streamvideo><streamvideourl></streamvideourl><streamvideototaltime>0</streamvideototaltime><streamvideotitle></streamvideotitle><streamvideowording></streamvideowording><streamvideoweburl></streamvideoweburl><streamvideothumburl></streamvideothumburl><streamvideoaduxinfo></streamvideoaduxinfo><streamvideopublishid></streamvideopublishid></streamvideo><canvasPageItem><canvasPageXml><![CDATA[]]></canvasPageXml></canvasPageItem><recorditem>&lt;recordinfo&gt;&lt;title&gt;&lt;/title&gt;&lt;desc&gt;E&#x20;&#x20;e&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;F&#x20;f&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;G&#x20;g\u8ddf\u8bfb&#x0A;[\u8bed\u97f3]3&amp;quot;&#x0A;[\u8bed\u97f3]4&amp;quot;&#x0A;[\u8bed\u97f3]3&amp;quot;...&lt;/desc&gt;&lt;datalist count=&apos;5&apos;&gt;&lt;dataitem datatype=&apos;8&apos; datastatus=&apos;0&apos; dataid=&apos;1b6ae16743192c74d51b10db5e63f95e&apos; htmlid=&apos;WeNoteHtmlFile&apos; dataillegaltype=&apos;0&apos;&gt;&lt;datafmt&gt;.htm&lt;/datafmt&gt;&lt;thumbwidth&gt;0&lt;/thumbwidth&gt;&lt;thumbheight&gt;0&lt;/thumbheight&gt;&lt;cdndataurl&gt;306002010004593057020100020430ebda7502033d0af50204324c977b020458f4ca4504353162366165313637343331393263373464353162313064623565363366393565407265636f72645f75706c6f6164403435363138320201000201000400&lt;/cdndataurl&gt;&lt;cdndatakey&gt;18a8b1a149a041b69be86b8fe0c226b2&lt;/cdndatakey&gt;&lt;fullmd5&gt;8a66fe784a0803228ff93883cc9be228&lt;/fullmd5&gt;&lt;head256md5&gt;7e565f82226bc8001c92f148ea626b42&lt;/head256md5&gt;&lt;datasize&gt;368&lt;/datasize&gt;&lt;/dataitem&gt;&lt;dataitem datatype=&apos;1&apos; datastatus=&apos;0&apos; dataid=&apos;405a062a228d5acb87afd5f4b7f1f5ee&apos; htmlid=&apos;-1&apos; dataillegaltype=&apos;0&apos;&gt;&lt;datadesc&gt;E&#x20;&#x20;e&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;F&#x20;f&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;&#x20;G&#x20;g\u8ddf\u8bfb&lt;/datadesc&gt;&lt;thumbwidth&gt;0&lt;/thumbwidth&gt;&lt;thumbheight&gt;0&lt;/thumbheight&gt;&lt;/dataitem&gt;&lt;dataitem datatype=&apos;3&apos; datastatus=&apos;0&apos; dataid=&apos;016c80f26084ea59ffec13db082a880c&apos; htmlid=&apos;WeNote_1&apos; dataillegaltype=&apos;0&apos;&gt;&lt;datafmt&gt;amr&lt;/datafmt&gt;&lt;thumbwidth&gt;0&lt;/thumbwidth&gt;&lt;thumbheight&gt;0&lt;/thumbheight&gt;&lt;cdndataurl&gt;306002010004593057020100020430ebda7502033d0af50204324c977b020458f4ca4504353031366338306632363038346561353966666563313364623038326138383063407265636f72645f75706c6f6164403435363138320201000201000400&lt;/cdndataurl&gt;&lt;cdndatakey&gt;8e9c2599f96f44f9a737401bb8d205f6&lt;/cdndatakey&gt;&lt;duration&gt;2718&lt;/duration&gt;&lt;fullmd5&gt;27f0d947a82a430caac33ab8fc6d53f6&lt;/fullmd5&gt;&lt;head256md5&gt;1d8741cf71cc7ffef6bd970687b3938d&lt;/head256md5&gt;&lt;datasize&gt;4070&lt;/datasize&gt;&lt;/dataitem&gt;&lt;dataitem datatype=&apos;3&apos; datastatus=&apos;0&apos; dataid=&apos;0804b8613e141e3d3a3d3d4a69866e48&apos; htmlid=&apos;WeNote_2&apos; dataillegaltype=&apos;0&apos;&gt;&lt;datafmt&gt;amr&lt;/datafmt&gt;&lt;thumbwidth&gt;0&lt;/thumbwidth&gt;&lt;thumbheight&gt;0&lt;/thumbheight&gt;&lt;cdndataurl&gt;306002010004593057020100020430ebda7502033d0af50204324c977b020458f4ca4404353038303462383631336531343165336433613364336434613639383636653438407265636f72645f75706c6f6164403435363138320201000201000400&lt;/cdndataurl&gt;&lt;cdndatakey&gt;28d6a99289d1491592b2adb05ba3b76a&lt;/cdndatakey&gt;&lt;duration&gt;3774&lt;/duration&gt;&lt;fullmd5&gt;f79786ef9521da19e845ddb8e3e8feb3&lt;/fullmd5&gt;&lt;head256md5&gt;1d8741cf71cc7ffef6bd970687b3938d&lt;/head256md5&gt;&lt;datasize&gt;5798&lt;/datasize&gt;&lt;/dataitem&gt;&lt;dataitem datatype=&apos;3&apos; datastatus=&apos;0&apos; dataid=&apos;a77011255579a940dbac8660084e3aa2&apos; htmlid=&apos;WeNote_3&apos; dataillegaltype=&apos;0&apos;&gt;&lt;datafmt&gt;amr&lt;/datafmt&gt;&lt;thumbwidth&gt;0&lt;/thumbwidth&gt;&lt;thumbheight&gt;0&lt;/thumbheight&gt;&lt;cdndataurl&gt;306002010004593057020100020430ebda7502033d0af50204324c977b020458f4ca4504356137373031313235353537396139343064626163383636303038346533616132407265636f72645f75706c6f6164403435363138320201000201000400&lt;/cdndataurl&gt;&lt;cdndatakey&gt;cf00662ec084439b87b9250b59c76631&lt;/cdndatakey&gt;&lt;duration&gt;2894&lt;/duration&gt;&lt;fullmd5&gt;39436553ac76b326aabbe4f60752239b&lt;/fullmd5&gt;&lt;head256md5&gt;1d8741cf71cc7ffef6bd970687b3938d&lt;/head256md5&gt;&lt;datasize&gt;4390&lt;/datasize&gt;&lt;/dataitem&gt;&lt;/datalist&gt;&lt;favusername&gt;&lt;/favusername&gt;&lt;/recordinfo&gt;</recorditem><appattach><totallen>0</totallen><attachid></attachid><cdnattachurl></cdnattachurl><emoticonmd5></emoticonmd5><aeskey></aeskey><fileext></fileext><islargefilemsg>0</islargefilemsg></appattach><extinfo></extinfo><androidsource>0</androidsource><thumburl></thumburl><mediatagname></mediatagname><messageaction><![CDATA[]]></messageaction><messageext><![CDATA[]]></messageext><emoticongift><packageflag>0</packageflag><packageid></packageid></emoticongift><emoticonshared><packageflag>0</packageflag><packageid></packageid></emoticonshared><weappinfo><username></username><appid></appid></weappinfo><designershared><designeruin>0</designeruin><designername>null</designername><designerrediretcturl>null</designerrediretcturl></designershared><emotionpageshared><tid>0</tid><title>null</title><desc>null</desc><iconUrl>null</iconUrl><secondUrl>null</secondUrl><pageType>0</pageType></emotionpageshared><webviewshared><shareUrlOriginal></shareUrlOriginal><shareUrlOpen></shareUrlOpen><jsAppId></jsAppId><publisherId></publisherId></webviewshared><template_id>0</template_id><statextstr></statextstr><md5></md5></appmsg><fromusername>wxid_212qrn9x586321</fromusername><scene>0</scene><appinfo><version>1</version><appname></appname></appinfo><commenturl></commenturl></msg>"));
        System.out.println(CardUtils.msgCardOutline("<msg><appmsg appid=\"wx91239ab32da78548\" sdkver=\"0\"><title></title><des>\u8ff7\u7cca\u841d\u8389\u5c0f\u72d0\u5996\uff0c\u6b63\u592a\u9053\u58eb\u6ca1\u8282\u64cd\u3002\u81ea\u53e4\u4eba\u5996\u751f\u6b7b\u604b\uff0c\u5343\u8f7d\u5b7d\u7f18\u4e00\u7ebf\u7275\uff01\uff08\u6ce8\uff1a\u72d0\u5996\u662f\u6bcf\u5468\u4e8c\u3001\u516d\u66f4\u65b0\u3002\uff09 \u547c\uff0c\u4eca\u5929\uff08\u5468\u4e8c\uff09\u7684\u66f4\u65b0\u5ef6\u8fdf\u5230\u660e\u65e9\uff08\u5468\u4e09\uff09\uff0c\u5927\u5bb6\u90fd\u61c2\u7684\u2026\u2026\uff08\u6bd5\u7adf\u6628\u5929\u51cc\u6668\u521a\u66f4\u65b0\u561b</des><action></action><type>5</type><showtype>0</showtype><soundtype>0</soundtype><mediatagname></mediatagname><messageext></messageext><messageaction></messageaction><content></content><contentattr>0</contentattr><url>http://m.ac.qq.com/Chapter/index/id/518333/seqno/1?flag=ios_share</url><lowurl></lowurl><dataurl></dataurl><lowdataurl></lowdataurl><appattach><totallen>0</totallen><attachid></attachid><emoticonmd5></emoticonmd5><fileext></fileext><cdnthumburl>304b020100044430420201000204a3a51e6302033d601f02040bc2c0b7020458f48dcb0420777869645f74366e333234637339346c39313231355f313439323432323039310201000201000400</cdnthumburl><cdnthumbmd5>e00eeaa573f580517a693021ed01be09</cdnthumbmd5><cdnthumblength>10105</cdnthumblength><cdnthumbwidth>114</cdnthumbwidth><cdnthumbheight>151</cdnthumbheight><cdnthumbaeskey>3747daa1b54d4e1d9cd9f13463958a0c</cdnthumbaeskey><aeskey>3747daa1b54d4e1d9cd9f13463958a0c</aeskey><encryver>0</encryver></appattach><extinfo></extinfo><sourceusername></sourceusername><sourcedisplayname></sourcedisplayname><thumburl></thumburl><md5></md5><statextstr>GhQKEnd4OTEyMzlhYjMyZGE3ODU0OA==</statextstr></appmsg><fromusername>rareyang</fromusername><scene>0</scene><appinfo><version>59</version><appname>\u817e\u8baf\u52a8\u6f2b</appname></appinfo><commenturl></commenturl></msg>"));
        System.out.println(CardUtils.msgCardOutline("<msg><appmsg appid=\"\" sdkver=\"0\"><title>untitled.zip</title><des></des><action></action><type>7</type><showtype>0</showtype><mediatagname></mediatagname><content></content><url></url><lowurl></lowurl><dataurl></dataurl><lowdataurl></lowdataurl><appattach><totallen>797933</totallen><attachid>@cdn_304b020100044430420201000204a3dc612502033d390d02043311a3b4020458f5ae690420777869645f6a65336179356e627a696972323233365f313439323439353937350201000201000400_e428550a302a406ba6c0e8b208b47b28_1</attachid><emoticonmd5></emoticonmd5><fileext>zip</fileext><cdnattachurl>304b020100044430420201000204a3dc612502033d390d02043311a3b4020458f5ae690420777869645f6a65336179356e627a696972323233365f313439323439353937350201000201000400</cdnattachurl><aeskey>e428550a302a406ba6c0e8b208b47b28</aeskey><encryver>0</encryver></appattach><extinfo></extinfo><sourceusername></sourceusername><sourcedisplayname></sourcedisplayname><commenturl></commenturl><thumburl></thumburl><md5>db58fb037af7a73b3339246f73a01315</md5></appmsg><fromusername>rareyang</fromusername><scene>0</scene><appinfo><version>1</version><appname></appname></appinfo><commenturl></commenturl></msg>"));
        System.out.println(CardUtils.msgCardOutline("<msg><appmsg appid=\"\" sdkver=\"0\"><title>\u4eca\u65e5\u5934\u6761lite</title><des>\u4eca\u65e5\u5934\u6761lite</des><action></action><type>33</type><showtype>0</showtype><soundtype>0</soundtype><mediatagname></mediatagname><messageext></messageext><messageaction></messageaction><content></content><contentattr>0</contentattr><url>https://mp.weixin.qq.com/mp/waerrpage?appid=wxa28f112e3da012f2&amp;type=upgrade#wechat_redirect</url><lowurl></lowurl><dataurl></dataurl><lowdataurl></lowdataurl><appattach><totallen>0</totallen><attachid></attachid><emoticonmd5></emoticonmd5><fileext></fileext><cdnthumburl>304c0201000445304302010002040c5f4ae002033d390d02047111a3b4020458f5a39a0421777869645f6a65336179356e627a69697232323631385f313439323439333231300201000201000400</cdnthumburl><cdnthumbmd5>ac6507db287b37f5c760916f39e50abd</cdnthumbmd5><cdnthumblength>400409</cdnthumblength><cdnthumbwidth>750</cdnthumbwidth><cdnthumbheight>1206</cdnthumbheight><cdnthumbaeskey>42b1897bc0f849088c4e6f1f412ce813</cdnthumbaeskey><aeskey>42b1897bc0f849088c4e6f1f412ce813</aeskey><encryver>0</encryver></appattach><extinfo></extinfo><sourceusername>gh_7687a2929db1@app</sourceusername><sourcedisplayname>\u4eca\u65e5\u5934\u6761lite</sourcedisplayname><thumburl></thumburl><md5></md5><statextstr></statextstr><weappinfo><username><![CDATA[gh_7687a2929db1@app]]></username><appid><![CDATA[wxa28f112e3da012f2]]></appid><type>2</type><version>3</version><weappiconurl><![CDATA[http://mmbiz.qpic.cn/mmbiz_png/17Pia1DNfSy2D5WBvwxsXABo73FjPJpCA6B236vcsiawXiar87VN4ZDzpGShicoFE6DtXyxazTj29OEPAkrRqlnagA/0?wx_fmt=png]]></weappiconurl><pagepath><![CDATA[pages/index/index.html]]></pagepath><shareId><![CDATA[0_wxa28f112e3da012f2_207571680_1492493209_0]]></shareId></weappinfo></appmsg><fromusername>rareyang</fromusername><scene>0</scene><appinfo><version>1</version><appname></appname></appinfo><commenturl></commenturl></msg>"));
    }

    private static String getOfficalCardNickname(String xmlContent) {
        return XmlUtils.getAttrbuteValue(xmlContent, "nickname", new String[0]);
    }

    private static Integer getMsgCardType(String xmlContent) {
        String str = XmlUtils.getValue(xmlContent, "appmsg", "type");
        if (NumberUtils.isNumber((String)str)) {
            return NumberUtils.toInt((String)str);
        }
        return null;
    }

    private static String getMsgCardTitle(String xmlContent) {
        return XmlUtils.getValue(xmlContent, "appmsg", "title");
    }

    private static String getMsgCardDesc(String xmlContent) {
        return XmlUtils.getValue(xmlContent, "appmsg", "des");
    }

    private static String getMsgCardAppname(String xmlContent) {
        return XmlUtils.getValue(xmlContent, "appinfo", "appname");
    }

    public static LinkMsgStuff genLinkMsgStuff(String xmlContent) throws DocumentException {
        LinkMsgStuff linkMsgStuff = new LinkMsgStuff();
        Document document = DocumentHelper.parseText((String)xmlContent);
        Element node = document.getRootElement();
        if (node != null) {
            Element appMsgNode = node.element("appmsg");
            linkMsgStuff.setTitle(XmlUtils.getElementValue(appMsgNode, "title"));
            linkMsgStuff.setUrl(XmlUtils.getElementValue(appMsgNode, "url"));
            linkMsgStuff.setDesc(XmlUtils.getElementValue(appMsgNode, "des"));
            linkMsgStuff.setThumbUrl(XmlUtils.getElementValue(appMsgNode, "thumburl"));
        }
        return linkMsgStuff;
    }

    private void chatHistoryComment() {
    }

    private void miniProgramComment() {
    }
}

