/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.processor.runner;

import com.baijia.storm.lib.moniclick.Resource;
import com.baijia.storm.lib.moniclick.WindowInfo;
import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.context.MoniClickContext;
import com.baijia.storm.lib.moniclick.processor.runner.CommandRunner;
import com.baijia.storm.lib.util.Log;
import com.baijia.storm.lib.util.StringUtils;
import java.util.List;
import java.util.regex.Pattern;

public class InputTxtCommandRunner
implements CommandRunner {
    @Override
    public int run(Command command, MoniClickContext context) {
        String params = command.getInstruction();
        if (StringUtils.isEmpty((CharSequence)params)) {
            Log.error("input txt command param is empty" + params);
            return CommandConstant.COMMAND_RES_BREAK_OPERATION;
        }
        String[] param = command.getInstruction().split(CommandConstant.PARAM_SEP);
        if (param.length < 2) {
            Log.error("input txt command param error" + params);
            return CommandConstant.COMMAND_RES_BREAK_OPERATION;
        }
        String buttonText = param[0];
        String inputText = param[1];
        WindowInfo windowInfo = context.getCurrentWindowInfo();
        Pattern pattern = Pattern.compile(buttonText);
        List<Resource> resourcesList = windowInfo.getResourceList();
        for (int i = 0; i < resourcesList.size(); ++i) {
            Resource resource = resourcesList.get(i);
            String text = resource.getText();
            if (StringUtils.isEmpty((CharSequence)text) || !pattern.matcher(text).matches()) continue;
            Log.debug(String.format("find button %s rect = %s", command.getInstruction(), resource.getBound().toString()));
            context.pastTextToViewByText(inputText, text);
            try {
                Thread.sleep(command.getDelay());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return CommandConstant.COMMAND_RES_CONTINUE;
        }
        return CommandConstant.COMMAND_RES_BREAK_OPERATION;
    }
}

