/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.processor.runner;

import com.baijia.storm.lib.moniclick.Resource;
import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.context.MoniClickContext;
import com.baijia.storm.lib.moniclick.processor.runner.CommandRunner;
import java.util.List;
import java.util.regex.Pattern;

public class ImgItemAnalysisClickCommandRunner
implements CommandRunner {
    @Override
    public int run(Command command, MoniClickContext context) {
        String screenPath = context.getCurrentScreen();
        List<Resource> resources = context.getImageBlock(screenPath);
        String instruction = command.getInstruction();
        Pattern pattern = Pattern.compile(instruction);
        for (Resource resource : resources) {
            String text = context.getSubImageText(screenPath, resource.getBound());
            if (text == null || !pattern.matcher(text).matches()) continue;
            String clickInstrunction = context.getInstructionFactory().getClickInstrunction(resource.getBound());
            return context.excuteInstruction(clickInstrunction, command.getDelay());
        }
        return CommandConstant.COMMAND_RES_BREAK_OPERATION;
    }
}

