/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.processor.runner;

import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.context.MoniClickContext;
import com.baijia.storm.lib.moniclick.processor.runner.CommandRunner;
import com.baijia.storm.lib.util.FileManager;
import com.baijia.storm.lib.util.Log;
import java.io.File;
import java.io.IOException;

public class ImgDownloadCommandRunner
implements CommandRunner {
    @Override
    public int run(Command command, MoniClickContext context) {
        String pathList = command.getInstruction();
        if (pathList == null) {
            Log.error("download path is null");
            return CommandConstant.COMMAND_RES_BREAK_OPERATION;
        }
        String[] paths = pathList.split(CommandConstant.PARAM_SEP);
        try {
            File targetDir = new File(context.getStorageimageTargetDir());
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            for (String p : paths) {
                Log.debug("download file: " + p);
                String cachePath = FileManager.instance().downLoadFile(p, context.getAppCacheDir());
                String targetPath = targetDir + "/" + new File(cachePath).getName();
                context.confuseImage(cachePath, targetPath);
            }
            context.sendScanFile(targetDir.getAbsolutePath());
            Thread.sleep(command.getDelay());
            return CommandConstant.COMMAND_RES_CONTINUE;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("img download failed");
            return CommandConstant.COMMAND_RES_CONTINUE;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return CommandConstant.COMMAND_RES_BREAK_OPERATION;
        }
    }
}

