/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.processor.runner;

import com.baijia.storm.lib.graph.CGRect;
import com.baijia.storm.lib.moniclick.Resource;
import com.baijia.storm.lib.moniclick.WindowInfo;
import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.context.MoniClickContext;
import com.baijia.storm.lib.moniclick.processor.runner.CommandRunner;
import com.baijia.storm.lib.util.Log;
import com.baijia.storm.lib.util.StringUtils;
import java.util.regex.Pattern;

public class FindButtonCommandRunner
implements CommandRunner {
    @Override
    public int run(Command command, MoniClickContext context) {
        String instruction = command.getInstruction();
        if (StringUtils.isEmpty((CharSequence)instruction)) {
            Log.error("command instruction is null in buttonfind");
            return CommandConstant.COMMAND_RES_BREAK_OPERATION;
        }
        WindowInfo windowInfo = context.getCurrentWindowInfo();
        Pattern pattern = Pattern.compile(instruction);
        for (Resource resource : windowInfo.getResourceList()) {
            String text = resource.getText();
            String desc = resource.getDesc();
            if (!resource.match(pattern)) continue;
            Log.debug(String.format("find button %s rect = %s", command.getInstruction(), resource.getBound().toString()));
            CGRect clickableRect = windowInfo.findClickableBlock(resource.getBound());
            Log.debug(String.format("find clickable rect = " + clickableRect.toString(), new Object[0]));
            String clickInstrunction = context.getInstructionFactory().getClickInstrunction(clickableRect);
            return context.excuteInstruction(clickInstrunction, command.getDelay());
        }
        Log.error("button not found:" + command.getInstruction());
        return CommandConstant.COMMAND_RES_BREAK_OPERATION;
    }
}

