/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.processor;

import com.baijia.storm.lib.moniclick.Operation;
import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.context.MoniClickContext;
import com.baijia.storm.lib.moniclick.processor.CommandProcessor;
import com.baijia.storm.lib.moniclick.processor.ConditionCommandProcessor;
import com.baijia.storm.lib.moniclick.processor.runner.CommandRunner;
import com.baijia.storm.lib.util.Log;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class OperationProcessor {
    MoniClickContext context;
    Queue<List<Operation>> cmdQueue = new LinkedBlockingQueue<List<Operation>>();
    static OperationProcessor processor;
    CommandProcessor commandProcessor;

    public static OperationProcessor getInstance(MoniClickContext context) throws IOException {
        if (processor == null) {
            processor = new OperationProcessor(context);
        }
        return processor;
    }

    public void registCommandRunner(int key, CommandRunner runner) {
        this.commandProcessor.registCommandRunner(key, runner);
    }

    private OperationProcessor(MoniClickContext context) throws IOException {
        this.context = context;
        this.commandProcessor = new ConditionCommandProcessor();
        new Thread(new CmdProcessorThread()).start();
    }

    public int processOperation(List<Operation> operationList) {
        if (this.cmdQueue == null) {
            return -1;
        }
        Log.debug("cmd processing : " + operationList.toString());
        this.cmdQueue.add(operationList);
        return 0;
    }

    private class CmdProcessorThread
    implements Runnable {
        private CmdProcessorThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (OperationProcessor.this.cmdQueue != null && OperationProcessor.this.cmdQueue.size() > 0) {
                            List<Operation> operationList = OperationProcessor.this.cmdQueue.poll();
                            for (Operation operation : operationList) {
                                List<Command> list;
                                Log.debug(" operation" + operation.toString());
                                if (operation == null || (list = operation.getCommandList()) == null || list.size() <= 0 || CommandConstant.COMMAND_RES_BREAK_OPERATION_LIST != OperationProcessor.this.commandProcessor.excute(list, OperationProcessor.this.context)) continue;
                                break;
                            }
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

