/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.processor;

import com.baijia.storm.lib.moniclick.WindowInfo;
import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.condition.BaseCondition;
import com.baijia.storm.lib.moniclick.command.condition.Condition;
import com.baijia.storm.lib.moniclick.command.condition.TextMatchCondition;
import com.baijia.storm.lib.moniclick.command.condition.WXHomePageCondition;
import com.baijia.storm.lib.moniclick.command.condition.WXPageCondition;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.context.MoniClickContext;
import com.baijia.storm.lib.moniclick.processor.CommandProcessor;
import com.baijia.storm.lib.util.Log;
import java.io.IOException;
import java.util.List;

public class ConditionCommandProcessor
extends CommandProcessor {
    @Override
    public int excute(List<Command> commandList, MoniClickContext context) {
        if (commandList != null && commandList.size() > 0) {
            for (Command cmd : commandList) {
                try {
                    int res = this.process(cmd, context);
                    if (res >= 0) continue;
                    return res;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return CommandConstant.COMMAND_RES_CONTINUE;
    }

    private int process(Command command, MoniClickContext context) throws IOException, InterruptedException {
        int res = 0;
        if (command.isCondition()) {
            BaseCondition baseCondition = command.getCondition();
            int conditionType = baseCondition.getConditionType();
            Condition condition = this.getConditionInstance(conditionType, baseCondition);
            Log.debug(" condition " + condition);
            int count = 0;
            while (condition != null && count < command.getMaxCount()) {
                WindowInfo windowInfo = context.getCurrentWindowInfo();
                boolean isProcess = false;
                boolean isContinue = false;
                boolean isBreak = false;
                ++count;
                if (condition.isProcess(windowInfo)) {
                    Log.debug(" process result is true");
                    isProcess = true;
                }
                if (condition.isBreak(windowInfo)) {
                    Log.debug("break result is ture");
                    isBreak = true;
                }
                if (condition.isContinue(windowInfo)) {
                    Log.debug(" continue result is continue");
                    isContinue = true;
                }
                if (isProcess && (res = this.processCommand(command, context)) < 0) {
                    return res;
                }
                if (isBreak) {
                    return CommandConstant.COMMAND_RES_BREAK_OPERATION;
                }
                if (isContinue) continue;
                break;
            }
        } else {
            res = this.processCommand(command, context);
            if (res < 0) {
                return res;
            }
        }
        return CommandConstant.COMMAND_RES_CONTINUE;
    }

    Condition getConditionInstance(int conditionType, BaseCondition condition) {
        switch (conditionType) {
            case 1: {
                return new TextMatchCondition(condition.getPattern().pattern(), condition.getMatchType());
            }
            case 2: {
                return new WXPageCondition(condition.getMatchType());
            }
            case 3: {
                return new WXHomePageCondition(condition.getMatchType());
            }
        }
        return null;
    }
}

