/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.processor;

import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.context.MoniClickContext;
import com.baijia.storm.lib.moniclick.processor.runner.CommandRunner;
import com.baijia.storm.lib.moniclick.processor.runner.CommonCommandRunner;
import com.baijia.storm.lib.moniclick.processor.runner.EmptyCommandRunner;
import com.baijia.storm.lib.moniclick.processor.runner.FindButtonCommandRunner;
import com.baijia.storm.lib.moniclick.processor.runner.ImgButtonExtractClickCommandRunner;
import com.baijia.storm.lib.moniclick.processor.runner.ImgDownloadCommandRunner;
import com.baijia.storm.lib.moniclick.processor.runner.ImgItemAnalysisClickCommandRunner;
import com.baijia.storm.lib.moniclick.processor.runner.InputTxtCommandRunner;
import com.baijia.storm.lib.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public abstract class CommandProcessor {
    HashMap<Integer, CommandRunner> runners = new HashMap();

    public void registCommandRunner(int key, CommandRunner runner) {
        this.runners.put(key, runner);
    }

    public CommandProcessor() {
        this.runners.put(CommandConstant.COMMAND_TYPE_EMPTY, new EmptyCommandRunner());
        this.runners.put(CommandConstant.COMMAND_TYPE_FIND_BUTTON, new FindButtonCommandRunner());
        this.runners.put(CommandConstant.COMMAND_TYPE_IMG_ITEM_ANALYSIS_CLICK, new ImgItemAnalysisClickCommandRunner());
        this.runners.put(CommandConstant.COMMAND_TYPE_IMG_BUTTON_EXTRACT_CLICK, new ImgButtonExtractClickCommandRunner());
        this.runners.put(CommandConstant.COMMAND_TYPE_IMG_DOWNLOAD, new ImgDownloadCommandRunner());
        this.runners.put(CommandConstant.COMMAND_TYPE_INPUT_TXT, new InputTxtCommandRunner());
        this.runners.put(CommandConstant.COMMAND_TYPE_COMMON, new CommonCommandRunner());
    }

    public int processCommand(Command command, MoniClickContext context) throws IOException, InterruptedException {
        CommandRunner runner = this.runners.get(command.getProcessType());
        if (runner == null) {
            Log.error("unsupported command:" + command.getProcessType());
            return CommandConstant.COMMAND_RES_BREAK_OPERATION;
        }
        try {
            return runner.run(command, context);
        }
        catch (Exception e) {
            Log.error("command process failed" + command.toString() + " " + e.toString());
            return CommandConstant.COMMAND_RES_BREAK_OPERATION;
        }
    }

    abstract int excute(List<Command> var1, MoniClickContext var2);
}

