/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.command.instruction;

import com.baijia.storm.lib.graph.CGPoint;
import com.baijia.storm.lib.graph.CGRect;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.command.instruction.InstructionFactory;
import com.baijia.storm.lib.moniclick.constant.ActionInfo;
import com.baijia.storm.lib.moniclick.constant.PackageInfo;
import com.baijia.storm.lib.moniclick.util.IntervalUtil;
import com.baijia.storm.lib.util.Log;
import java.util.HashMap;
import java.util.Random;

public class AndroidNormalInstructionFactory
implements InstructionFactory {
    Random random = new Random(System.currentTimeMillis());
    HashMap<String, String> launchAppKeyMap = new HashMap();
    HashMap<String, String> launchActionKeyMap = new HashMap();

    public AndroidNormalInstructionFactory() {
        this.launchAppKeyMap.put(PackageInfo.WX_PACKAGE, "com.tencent.mm/com.tencent.mm.ui.LauncherUI");
        this.launchActionKeyMap.put(ActionInfo.SETTINGS, "android.settings.SETTINGS");
        this.launchActionKeyMap.put(ActionInfo.ACCESSIBILITY_SETTINGS, "android.settings.SETTINGS");
    }

    @Override
    public String getGoHomeInstruction() {
        return "input keyevent keyCode KEYCODE_HOME";
    }

    @Override
    public String getBackInstruction() {
        return "input keyevent keyCode KEYCODE_BACK";
    }

    @Override
    public String getEnterInstruction() {
        return "input keyevent keyCode KEYCODE_ENTER";
    }

    @Override
    public String getSearchInstruction() {
        return "input keyevent keyCode KEYCODE_SEARCH";
    }

    @Override
    public String swipeUp(CGRect rect) {
        return null;
    }

    @Override
    public String swipeDown(CGRect rect) {
        return null;
    }

    @Override
    public String longClick(CGRect rect) {
        CGPoint clickPoint = rect.getSubRect(CommandConstant.RECT_CLICK_RATIO).getRandomPoint();
        return String.format("input swipe %d %d %d %d %d", clickPoint.getX(), clickPoint.getY(), clickPoint.getX(), clickPoint.getY(), IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
    }

    @Override
    public String changeOwn(String uid, String path) {
        return String.format("chown %s:%s %s", uid, uid, path);
    }

    @Override
    public String getClickInstruction(int x, int y) {
        return String.format("input tap %d %d", x, y);
    }

    @Override
    public String getClickInstrunction(CGRect rect) {
        CGPoint clickPoint = rect.getSubRect(CommandConstant.RECT_CLICK_RATIO).getRandomPoint();
        return String.format("input swipe %d %d %d %d 100", clickPoint.getX(), clickPoint.getY(), clickPoint.getX() + 10, clickPoint.getY() + 10);
    }

    @Override
    public String getSwipeInstrunction(CGPoint p1, CGPoint p2, int last) {
        int curRand = (int)(this.random.nextFloat() * 200.0f - 100.0f);
        int x1 = Math.max(p1.getX() + curRand, 50);
        curRand = (int)(this.random.nextFloat() * 200.0f - 100.0f);
        int x2 = Math.max(p2.getX() + curRand, 50);
        curRand = (int)(this.random.nextFloat() * 200.0f - 100.0f);
        int y1 = Math.max(p1.getY() + curRand, 50);
        curRand = (int)(this.random.nextFloat() * 200.0f - 100.0f);
        int y2 = Math.max(p2.getY() + curRand, 50);
        return String.format("input swipe %d %d %d %d %d", p1.getX(), p1.getY(), p2.getX(), p2.getY(), last);
    }

    @Override
    public String launchAPP(String appKey) {
        if (this.launchAppKeyMap.containsKey(appKey)) {
            return "am start " + this.launchAppKeyMap.get(appKey);
        }
        Log.error("instruction app not suppot :" + appKey);
        return null;
    }

    @Override
    public String inputText(String text) {
        return String.format("input text %s ", text);
    }

    public String launchAction(String actionKey) {
        if (this.launchActionKeyMap.containsKey(actionKey)) {
            return "am start -a " + this.launchActionKeyMap.get(actionKey);
        }
        Log.error("instruction action not suppot :" + actionKey);
        return null;
    }
}

