/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.command.condition;

import com.baijia.storm.lib.moniclick.Resource;
import com.baijia.storm.lib.moniclick.WindowInfo;
import com.baijia.storm.lib.moniclick.command.condition.Condition;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.util.Log;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class WXHomePageCondition
extends Condition {
    public WXHomePageCondition(int matchType) {
        super(matchType, CommandConstant.CONDITION_TYPE_WXHOME);
    }

    @Override
    public boolean isMatch(WindowInfo windowInfo) {
        if (windowInfo == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("\u5f53\u524d\u6240\u5728\u9875\u9762,\u4e0e.*\u7684\u804a\u5929");
        String firstDesc = windowInfo.getFirstDesc();
        if (StringUtils.isEmpty((CharSequence)firstDesc)) {
            return false;
        }
        Log.debug("check is wxhome " + windowInfo.getFirstDesc());
        if (!pattern.matcher(firstDesc).matches()) {
            return false;
        }
        for (Resource resource : windowInfo.getResourceList()) {
            String desc = resource.getDesc();
            if (desc == null || !desc.equals("\u8fd4\u56de")) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "WXHomePageCondition{\"matchType=" + this.matchType + "\"" + '}';
    }
}

