/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.moniclick.command;

import com.baijia.storm.lib.graph.CGPoint;
import com.baijia.storm.lib.moniclick.command.Command;
import com.baijia.storm.lib.moniclick.command.condition.TextMatchCondition;
import com.baijia.storm.lib.moniclick.command.condition.WXHomePageCondition;
import com.baijia.storm.lib.moniclick.command.constant.CommandConstant;
import com.baijia.storm.lib.moniclick.command.instruction.AndroidNormalInstructionFactory;
import com.baijia.storm.lib.moniclick.command.instruction.InstructionFactory;
import com.baijia.storm.lib.moniclick.constant.PackageInfo;
import com.baijia.storm.lib.moniclick.util.IntervalUtil;
import java.util.Random;

public class CommandFactory {
    static InstructionFactory instructionFactory = new AndroidNormalInstructionFactory();
    static Random rand = new Random(System.currentTimeMillis());

    public static Command getClickButtonCommand(String cmd, int delay) {
        Command command = new Command(cmd, IntervalUtil.timeRandom(delay));
        command.setProcessType(CommandConstant.COMMAND_TYPE_FIND_BUTTON);
        return command;
    }

    public static Command getClickButtonCommand(String cmd) {
        return CommandFactory.getClickButtonCommand(cmd, IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
    }

    public static Command getEnterCommand() {
        Command command = new Command(instructionFactory.getEnterInstruction(), IntervalUtil.timeRandom(CommandConstant.LONG_WAIT));
        return command;
    }

    public static Command getHomeCommand() {
        Command homeCommand = new Command(instructionFactory.getGoHomeInstruction(), IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
        return homeCommand;
    }

    public static Command getBackCommand() {
        Command command = new Command(instructionFactory.getBackInstruction(), IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
        return command;
    }

    public static Command getWXHomeCommand() {
        Command backCommand = CommandFactory.getClickButtonCommand("\u8fd4\u56de", IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
        backCommand.setIsConditon(true);
        backCommand.setMaxCount(20);
        backCommand.setCondition(new WXHomePageCondition(CommandConstant.COMMAND_CONDITION_UNMATCH_PROCESS_MASK | CommandConstant.COMMAND_CONDITION_UNMATCH_CONTINUE_MASK));
        return backCommand;
    }

    public static Command getOpenWXCommand() {
        Command command = new Command(instructionFactory.launchAPP(PackageInfo.WX_PACKAGE), IntervalUtil.timeRandom(CommandConstant.LONG_WAIT));
        return command;
    }

    public static Command getEmptyCommand() {
        Command empty = new Command("", IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
        empty.setProcessType(CommandConstant.COMMAND_TYPE_EMPTY);
        return empty;
    }

    public static Command getSearchCommand() {
        Command command = new Command(instructionFactory.getSearchInstruction(), IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
        return command;
    }

    public static Command getDownLoadImageCommand(String imagePath) {
        Command command = new Command(imagePath, IntervalUtil.timeRandom(CommandConstant.LONG_WAIT));
        command.setProcessType(CommandConstant.COMMAND_TYPE_IMG_DOWNLOAD);
        return command;
    }

    public static Command getItemFromImageCommand(String text) {
        Command command = new Command(text, IntervalUtil.timeRandom(CommandConstant.LONG_WAIT));
        command.setProcessType(CommandConstant.COMMAND_TYPE_IMG_ITEM_ANALYSIS_CLICK);
        return command;
    }

    public static Command getInputTextCommand(String buttonText, String inputText) {
        Command command = new Command(String.format("%s%s%s", buttonText, CommandConstant.PARAM_SEP, inputText), CommandConstant.SHOT_WAIT);
        command.setProcessType(CommandConstant.COMMAND_TYPE_INPUT_TXT);
        return command;
    }

    public static Command getTextConditionCommand(Command command, String matchText, int matchType) {
        TextMatchCondition condition = new TextMatchCondition(matchText, matchType);
        command.setIsConditon(true);
        command.setCondition(condition);
        return command;
    }

    public static Command getButtonFoundClick(String text) {
        return CommandFactory.getTextConditionCommand(CommandFactory.getClickButtonCommand(text), text, CommandConstant.COMMAND_CONDITION_MATCH_PROCESS_MASK);
    }

    public static Command getSwipeCommand(int x1, int y1, int x2, int y2, int moveTime) {
        return new Command(instructionFactory.getSwipeInstrunction(new CGPoint(x1, y1), new CGPoint(x2, y2), moveTime), IntervalUtil.timeRandom(CommandConstant.SHOT_WAIT));
    }

    public static Command getSwipeCommand(int x1, int y1, int x2, int y2, int moveTime, int delay) {
        return new Command(instructionFactory.getSwipeInstrunction(new CGPoint(x1, y1), new CGPoint(x2, y2), moveTime), IntervalUtil.timeRandom(delay));
    }
}

