/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.storm.lib.graph;

import com.baijia.storm.lib.graph.CGPoint;
import java.util.Random;

public class CGRect {
    int x;
    int y;
    int width;
    int height;

    public CGRect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public CGPoint getCenter() {
        return new CGPoint(this.x + this.width / 2, this.y + this.height / 2);
    }

    public boolean contains(CGRect rect) {
        if (rect.getX() < this.x) {
            return false;
        }
        if (rect.getY() < this.y) {
            return false;
        }
        if (rect.getX() + rect.width > this.x + this.width) {
            return false;
        }
        return rect.getY() + rect.getHeight() <= this.y + this.height;
    }

    public CGRect getSubRect(double ratio) {
        int newX = (int)((double)this.x + (1.0 - ratio) / 2.0 * (double)this.width);
        int newY = (int)((double)this.y + (1.0 - ratio) / 2.0 * (double)this.height);
        int newWidth = (int)((double)this.width * ratio);
        int newHeight = (int)((double)this.height * ratio);
        return new CGRect(newX, newY, newWidth, newHeight);
    }

    public CGPoint getRandomPoint() {
        Random random = new Random(System.currentTimeMillis());
        int xRandom = (int)(random.nextFloat() * (float)this.width);
        int yRandom = (int)(random.nextFloat() * (float)this.height);
        return new CGPoint(xRandom + this.x, yRandom + this.y);
    }

    public String toString() {
        return "CGRect [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

