package com.baijia.snowflake.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.util.List;

/**
 * @Author KaiJia
 * @DATE 2016-09-12
 */
@Slf4j
public class SClientImpl implements SClient {
    private static final int retries = 3;

    private String host;

    private Gson gson = new Gson();

    public SClientImpl(String host) {
        this.host = host;
    }

    private String httpGet(int n) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();

            HttpGet method = new HttpGet(host + "/get?n=" + String.valueOf(n));

            HttpResponse httpResponse = httpClient.execute(method);
            if (httpResponse == null || httpResponse.getStatusLine() == null) {
                log.error("[SClient] [get] SYS_ERROR [httpResponse is invalid]");
                return null;
            }

            if (HttpStatus.SC_OK != httpResponse.getStatusLine().getStatusCode()) {
                log.error("[SClient] [get] SYS_ERROR [httpStatus != 200]");
                log.error("[SClient] [get] [response status:" + httpResponse.getStatusLine().getStatusCode() + "]");
                return null;
            }

            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                log.error("[SClient] [get] SYS_ERROR [httpEntity is null]");
                return null;
            }

            return EntityUtils.toString(httpEntity);
        } catch (Exception e) {
            log.error("[SClient] [get] SYS_ERROR", e);
            return null;
        } finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                } catch (Exception e) {
                    log.error("[SClient] [get] SYS_ERROR [free resource failed]", e);
                }
            }
        }
    }

    private boolean isValid() {
        return host != null;
    }

    @Override
    public List<Long> get(int n) {
        if (!isValid()) {
            log.error("SClient is invalid.");
            return null;
        }
        for (int i = 0; i < retries; i++) {
            String json = httpGet(n);
            if (json == null) {
                log.warn("SClient failed at {} times", i);
                try {
                    Thread.sleep(50);
                } catch (InterruptedException e) {
                    log.error("SYS_ERROR", e);
                }
            } else {
                return gson.fromJson(json, new TypeToken<List<Long>>(){}.getType());
            }
        }
        log.error("SClient retries {} times still failed", retries);
        return null;
    }

    @Override
    public Long getOne() {
        return get(1).get(0);
    }
}
