/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.robotcenter.facade.live.request;

import com.baijia.robotcenter.facade.live.enums.CourseSourceEnum;
import com.baijia.robotcenter.facade.live.enums.CourseTypeEnum;
import com.baijia.robotcenter.facade.request.ValidateRequest;
import com.baijia.support.web.dto.PageDto;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseRequest
implements ValidateRequest {
    private static final Logger log = LoggerFactory.getLogger(CourseRequest.class);
    private PageDto pageDto;
    private Long courseCode;
    private String chatroom;
    private Boolean requireCourseCompleted;
    private String topic;
    private String courseImageUrl;
    private String courseImageName;
    private String teacherDisplayName;
    private Object intro;
    private Date beginTime;
    private Integer auditionMinutes = 0;
    private String masterChatroom;
    private List<String> slaveChatroomList;
    private List<String> teacherUsernameList;
    private Long replayBaseLiveRoomNum;
    private List<String> tempLiveChatroomList;
    private Integer price = 0;
    private Boolean needRecord = true;
    private Integer taskType;
    private Integer source;
    private Boolean isFree;
    private String password;
    private Boolean isPublish = false;
    private Integer courseType;
    private Long liveRoomNum;
    private Long courseCategoryId;
    private Long columnId;
    private String name;
    private String columnImageUrl;
    private String columnImageName;
    private Long columnCode;
    private Long inviteCode;
    private Integer status;
    private Boolean isSkipIntro;
    private Integer courseContentSource;
    private Boolean requireOnSale;
    private Boolean isOnSale = false;
    private Boolean isStopUpdate = false;
    private String appId;
    private Boolean isAuditionClass = false;
    private Boolean hasBeenCourse;
    private Integer expectCount = 0;
    private String SourceUrl;
    private Long tid;
    private String audioUrl;
    private String audioName;
    private Long duration;
    private String sourceCode;
    private String url;
    private String imageName;
    private Integer taskId;

    @Override
    public boolean validate() {
        return this.pageDto == null || this.isPositiveNum(this.pageDto.getPageNum()) && this.isPositiveNum(this.pageDto.getPageSize());
    }

    public boolean validateAddCourseRequest() {
        if (this.columnCode == null) {
            if (this.courseType == null) {
                return false;
            }
            if (this.courseType.intValue() == CourseTypeEnum.PASSWORD.getCode() && StringUtils.isBlank((String)this.password)) {
                return false;
            }
            if (this.courseType.intValue() == CourseTypeEnum.CHARGE.getCode() && (this.price == null || this.price <= 0)) {
                return false;
            }
        }
        return StringUtils.isNotBlank((String)this.topic) && StringUtils.isNotBlank((String)this.teacherDisplayName) && this.liveRoomNum != null && this.isSkipIntro != null;
    }

    public boolean validateModifyCourseRequest() {
        return this.validateAddCourseRequest() && this.courseCode != null;
    }

    public boolean validateAddChatroomLiveTaskRequest() {
        return StringUtils.isNotBlank((String)this.topic) && this.beginTime != null && this.taskType != null;
    }

    public boolean validateAddLiveTaskRequest() {
        if (this.source == null) {
            return false;
        }
        if (this.source.intValue() == CourseSourceEnum.WECHAT_CHATROOM_LIVE.getCode()) {
            return this.validateAddChatroomLiveTaskRequest();
        }
        if (this.source.intValue() == CourseSourceEnum.H5_LIVE.getCode()) {
            return this.validateAddWebLiveTaskRequest();
        }
        return false;
    }

    public boolean validateModifyChatroomLiveTaskRequest() {
        return this.validateAddChatroomLiveTaskRequest() && this.liveRoomNum != null;
    }

    public boolean validateModifyLiveTaskRequest() {
        if (this.source == null) {
            return false;
        }
        if (this.source.intValue() == CourseSourceEnum.WECHAT_CHATROOM_LIVE.getCode()) {
            return this.validateModifyChatroomLiveTaskRequest();
        }
        if (this.source.intValue() == CourseSourceEnum.H5_LIVE.getCode()) {
            return this.validateModifyWebLiveTaskRequest();
        }
        return false;
    }

    public boolean validateAddWebLiveTaskRequest() {
        return StringUtils.isNotBlank((String)this.topic) && this.beginTime != null;
    }

    public boolean validateModifyWebLiveTaskRequest() {
        return this.validateAddWebLiveTaskRequest() && this.liveRoomNum != null;
    }

    public boolean validateStopRecordRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateDeleteLiveTaskRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateQueryChatroomLiveTaskListRequest() {
        return this.validate() && this.pageDto != null;
    }

    public boolean validateQueryWebLiveTaskListRequest() {
        return this.validate() && this.pageDto != null;
    }

    public boolean validateQueryChatroomLiveTaskDetailRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateQueryWebLiveTaskDetailRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateQueryChatroomMemberInfoList() {
        return StringUtils.isNotBlank((String)this.chatroom);
    }

    public boolean validateAddCourseColumnRequest() {
        return this.name != null && this.expectCount != null && this.courseType != null && (this.courseType.intValue() != CourseTypeEnum.PASSWORD.getCode() || StringUtils.isNotBlank((String)this.password)) && (this.courseType.intValue() != CourseTypeEnum.CHARGE.getCode() || this.price != null && this.price > 0);
    }

    public boolean validateModifyCourseColumnRequest() {
        return this.validateAddCourseColumnRequest() && this.columnCode != null;
    }

    public boolean validateDeleteCourseColumnRequest() {
        return this.columnCode != null;
    }

    public boolean validateQueryCourseColumnDetailRequest() {
        return this.columnCode != null;
    }

    public boolean validateQueryCourseColumnListRequest() {
        return this.validate() && this.pageDto != null;
    }

    public boolean validateGetInviteTeacherLinkRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateAcceptTeacherInviteRequest() {
        return this.inviteCode != null;
    }

    public boolean validateDeleteCourseRequest() {
        return this.courseCode != null;
    }

    public boolean validateQueryCourseDetailRequest() {
        return this.courseCode != null;
    }

    public boolean validateQueryCourseListRequest() {
        return this.validate() && this.pageDto != null;
    }

    public boolean validateQueryLiveTaskDetailRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateQueryLiveTaskListRequest() {
        return this.validate() && this.pageDto != null;
    }

    public boolean validateToggleSaleStatusRequest() {
        return this.courseCode != null && this.isOnSale != null;
    }

    public boolean validateToggleCourseColumnOnSaleStatusRequest() {
        return this.columnCode != null && this.isOnSale != null;
    }

    public boolean validateToggleCourseColumnUpdateStatusRequest() {
        return this.columnCode != null && this.isStopUpdate != null;
    }

    public boolean validateQueryColumnCourseListRequest() {
        return this.columnCode != null;
    }

    public boolean validatePay4CourseRequest() {
        return this.courseCode != null;
    }

    public boolean validatePay4ColumnRequest() {
        return this.columnCode != null;
    }

    public boolean validateAddAccountAuthorizeGongzhonghaoRequest() {
        return this.appId != null;
    }

    public boolean validateQueryLiveFlagRequest() {
        return this.courseCode != null;
    }

    public boolean validateSetAuditionRequest() {
        return this.courseCode != null && this.isAuditionClass != null;
    }

    public boolean validateSendColumnLinkRequest() {
        return this.columnCode != null;
    }

    public boolean validateSendCourseLinkRequest() {
        return this.courseCode != null;
    }

    public boolean validateQueryTid2LiveRoomNumRequest() {
        return this.tid != null;
    }

    public boolean validateReportPvRequest() {
        return this.columnCode != null || this.courseCode != null;
    }

    public boolean validateQueryLiveFlagByLiveRoomNumRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateQueryTaskInfoRequest() {
        return this.liveRoomNum != null;
    }

    public boolean validateAddAudioRequest() {
        if (this.columnCode == null) {
            if (this.courseType == null) {
                return false;
            }
            if (this.courseType.intValue() == CourseTypeEnum.PASSWORD.getCode() && StringUtils.isBlank((String)this.password)) {
                return false;
            }
            if (this.courseType.intValue() == CourseTypeEnum.CHARGE.getCode() && (this.price == null || this.price <= 0)) {
                return false;
            }
        }
        return StringUtils.isNotBlank((String)this.topic) && this.isSkipIntro != null && StringUtils.isNotBlank((String)this.audioUrl) && StringUtils.isNotBlank((String)this.audioName);
    }

    public boolean validateModifyAudioRequest() {
        return this.validateAddAudioRequest() && this.courseCode != null;
    }

    public boolean validateModifySpecializedUrlRequest() {
        return StringUtils.isNotBlank((String)this.url) && StringUtils.isNotBlank((String)this.imageName);
    }

    public boolean validateQuerySourceQrcodeRequest() {
        return StringUtils.isNotBlank((String)this.sourceCode) && (this.courseCode != null || this.columnCode != null);
    }

    public boolean validateAddMerchandiseTaskIdConnReqeust() {
        return (this.courseCode != null || this.columnCode != null) && this.taskId != null;
    }

    private boolean isPositiveNum(Integer num) {
        return num == null ? false : num > 0;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public Long getCourseCode() {
        return this.courseCode;
    }

    public String getChatroom() {
        return this.chatroom;
    }

    public Boolean getRequireCourseCompleted() {
        return this.requireCourseCompleted;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getCourseImageUrl() {
        return this.courseImageUrl;
    }

    public String getCourseImageName() {
        return this.courseImageName;
    }

    public String getTeacherDisplayName() {
        return this.teacherDisplayName;
    }

    public Object getIntro() {
        return this.intro;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Integer getAuditionMinutes() {
        return this.auditionMinutes;
    }

    public String getMasterChatroom() {
        return this.masterChatroom;
    }

    public List<String> getSlaveChatroomList() {
        return this.slaveChatroomList;
    }

    public List<String> getTeacherUsernameList() {
        return this.teacherUsernameList;
    }

    public Long getReplayBaseLiveRoomNum() {
        return this.replayBaseLiveRoomNum;
    }

    public List<String> getTempLiveChatroomList() {
        return this.tempLiveChatroomList;
    }

    public Integer getPrice() {
        return this.price;
    }

    public Boolean getNeedRecord() {
        return this.needRecord;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Integer getSource() {
        return this.source;
    }

    public Boolean getIsFree() {
        return this.isFree;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getIsPublish() {
        return this.isPublish;
    }

    public Integer getCourseType() {
        return this.courseType;
    }

    public Long getLiveRoomNum() {
        return this.liveRoomNum;
    }

    public Long getCourseCategoryId() {
        return this.courseCategoryId;
    }

    public Long getColumnId() {
        return this.columnId;
    }

    public String getName() {
        return this.name;
    }

    public String getColumnImageUrl() {
        return this.columnImageUrl;
    }

    public String getColumnImageName() {
        return this.columnImageName;
    }

    public Long getColumnCode() {
        return this.columnCode;
    }

    public Long getInviteCode() {
        return this.inviteCode;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Boolean getIsSkipIntro() {
        return this.isSkipIntro;
    }

    public Integer getCourseContentSource() {
        return this.courseContentSource;
    }

    public Boolean getRequireOnSale() {
        return this.requireOnSale;
    }

    public Boolean getIsOnSale() {
        return this.isOnSale;
    }

    public Boolean getIsStopUpdate() {
        return this.isStopUpdate;
    }

    public String getAppId() {
        return this.appId;
    }

    public Boolean getIsAuditionClass() {
        return this.isAuditionClass;
    }

    public Boolean getHasBeenCourse() {
        return this.hasBeenCourse;
    }

    public Integer getExpectCount() {
        return this.expectCount;
    }

    public String getSourceUrl() {
        return this.SourceUrl;
    }

    public Long getTid() {
        return this.tid;
    }

    public String getAudioUrl() {
        return this.audioUrl;
    }

    public String getAudioName() {
        return this.audioName;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public String getUrl() {
        return this.url;
    }

    public String getImageName() {
        return this.imageName;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setCourseCode(Long courseCode) {
        this.courseCode = courseCode;
    }

    public void setChatroom(String chatroom) {
        this.chatroom = chatroom;
    }

    public void setRequireCourseCompleted(Boolean requireCourseCompleted) {
        this.requireCourseCompleted = requireCourseCompleted;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setCourseImageUrl(String courseImageUrl) {
        this.courseImageUrl = courseImageUrl;
    }

    public void setCourseImageName(String courseImageName) {
        this.courseImageName = courseImageName;
    }

    public void setTeacherDisplayName(String teacherDisplayName) {
        this.teacherDisplayName = teacherDisplayName;
    }

    public void setIntro(Object intro) {
        this.intro = intro;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public void setAuditionMinutes(Integer auditionMinutes) {
        this.auditionMinutes = auditionMinutes;
    }

    public void setMasterChatroom(String masterChatroom) {
        this.masterChatroom = masterChatroom;
    }

    public void setSlaveChatroomList(List<String> slaveChatroomList) {
        this.slaveChatroomList = slaveChatroomList;
    }

    public void setTeacherUsernameList(List<String> teacherUsernameList) {
        this.teacherUsernameList = teacherUsernameList;
    }

    public void setReplayBaseLiveRoomNum(Long replayBaseLiveRoomNum) {
        this.replayBaseLiveRoomNum = replayBaseLiveRoomNum;
    }

    public void setTempLiveChatroomList(List<String> tempLiveChatroomList) {
        this.tempLiveChatroomList = tempLiveChatroomList;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public void setNeedRecord(Boolean needRecord) {
        this.needRecord = needRecord;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public void setIsFree(Boolean isFree) {
        this.isFree = isFree;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIsPublish(Boolean isPublish) {
        this.isPublish = isPublish;
    }

    public void setCourseType(Integer courseType) {
        this.courseType = courseType;
    }

    public void setLiveRoomNum(Long liveRoomNum) {
        this.liveRoomNum = liveRoomNum;
    }

    public void setCourseCategoryId(Long courseCategoryId) {
        this.courseCategoryId = courseCategoryId;
    }

    public void setColumnId(Long columnId) {
        this.columnId = columnId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColumnImageUrl(String columnImageUrl) {
        this.columnImageUrl = columnImageUrl;
    }

    public void setColumnImageName(String columnImageName) {
        this.columnImageName = columnImageName;
    }

    public void setColumnCode(Long columnCode) {
        this.columnCode = columnCode;
    }

    public void setInviteCode(Long inviteCode) {
        this.inviteCode = inviteCode;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setIsSkipIntro(Boolean isSkipIntro) {
        this.isSkipIntro = isSkipIntro;
    }

    public void setCourseContentSource(Integer courseContentSource) {
        this.courseContentSource = courseContentSource;
    }

    public void setRequireOnSale(Boolean requireOnSale) {
        this.requireOnSale = requireOnSale;
    }

    public void setIsOnSale(Boolean isOnSale) {
        this.isOnSale = isOnSale;
    }

    public void setIsStopUpdate(Boolean isStopUpdate) {
        this.isStopUpdate = isStopUpdate;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setIsAuditionClass(Boolean isAuditionClass) {
        this.isAuditionClass = isAuditionClass;
    }

    public void setHasBeenCourse(Boolean hasBeenCourse) {
        this.hasBeenCourse = hasBeenCourse;
    }

    public void setExpectCount(Integer expectCount) {
        this.expectCount = expectCount;
    }

    public void setSourceUrl(String SourceUrl) {
        this.SourceUrl = SourceUrl;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public void setAudioUrl(String audioUrl) {
        this.audioUrl = audioUrl;
    }

    public void setAudioName(String audioName) {
        this.audioName = audioName;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setTaskId(Integer taskId) {
        this.taskId = taskId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CourseRequest)) {
            return false;
        }
        CourseRequest other = (CourseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        Long this$courseCode = this.getCourseCode();
        Long other$courseCode = other.getCourseCode();
        if (this$courseCode == null ? other$courseCode != null : !((Object)this$courseCode).equals(other$courseCode)) {
            return false;
        }
        String this$chatroom = this.getChatroom();
        String other$chatroom = other.getChatroom();
        if (this$chatroom == null ? other$chatroom != null : !this$chatroom.equals(other$chatroom)) {
            return false;
        }
        Boolean this$requireCourseCompleted = this.getRequireCourseCompleted();
        Boolean other$requireCourseCompleted = other.getRequireCourseCompleted();
        if (this$requireCourseCompleted == null ? other$requireCourseCompleted != null : !((Object)this$requireCourseCompleted).equals(other$requireCourseCompleted)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$courseImageUrl = this.getCourseImageUrl();
        String other$courseImageUrl = other.getCourseImageUrl();
        if (this$courseImageUrl == null ? other$courseImageUrl != null : !this$courseImageUrl.equals(other$courseImageUrl)) {
            return false;
        }
        String this$courseImageName = this.getCourseImageName();
        String other$courseImageName = other.getCourseImageName();
        if (this$courseImageName == null ? other$courseImageName != null : !this$courseImageName.equals(other$courseImageName)) {
            return false;
        }
        String this$teacherDisplayName = this.getTeacherDisplayName();
        String other$teacherDisplayName = other.getTeacherDisplayName();
        if (this$teacherDisplayName == null ? other$teacherDisplayName != null : !this$teacherDisplayName.equals(other$teacherDisplayName)) {
            return false;
        }
        Object this$intro = this.getIntro();
        Object other$intro = other.getIntro();
        if (this$intro == null ? other$intro != null : !this$intro.equals(other$intro)) {
            return false;
        }
        Date this$beginTime = this.getBeginTime();
        Date other$beginTime = other.getBeginTime();
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        Integer this$auditionMinutes = this.getAuditionMinutes();
        Integer other$auditionMinutes = other.getAuditionMinutes();
        if (this$auditionMinutes == null ? other$auditionMinutes != null : !((Object)this$auditionMinutes).equals(other$auditionMinutes)) {
            return false;
        }
        String this$masterChatroom = this.getMasterChatroom();
        String other$masterChatroom = other.getMasterChatroom();
        if (this$masterChatroom == null ? other$masterChatroom != null : !this$masterChatroom.equals(other$masterChatroom)) {
            return false;
        }
        List<String> this$slaveChatroomList = this.getSlaveChatroomList();
        List<String> other$slaveChatroomList = other.getSlaveChatroomList();
        if (this$slaveChatroomList == null ? other$slaveChatroomList != null : !((Object)this$slaveChatroomList).equals(other$slaveChatroomList)) {
            return false;
        }
        List<String> this$teacherUsernameList = this.getTeacherUsernameList();
        List<String> other$teacherUsernameList = other.getTeacherUsernameList();
        if (this$teacherUsernameList == null ? other$teacherUsernameList != null : !((Object)this$teacherUsernameList).equals(other$teacherUsernameList)) {
            return false;
        }
        Long this$replayBaseLiveRoomNum = this.getReplayBaseLiveRoomNum();
        Long other$replayBaseLiveRoomNum = other.getReplayBaseLiveRoomNum();
        if (this$replayBaseLiveRoomNum == null ? other$replayBaseLiveRoomNum != null : !((Object)this$replayBaseLiveRoomNum).equals(other$replayBaseLiveRoomNum)) {
            return false;
        }
        List<String> this$tempLiveChatroomList = this.getTempLiveChatroomList();
        List<String> other$tempLiveChatroomList = other.getTempLiveChatroomList();
        if (this$tempLiveChatroomList == null ? other$tempLiveChatroomList != null : !((Object)this$tempLiveChatroomList).equals(other$tempLiveChatroomList)) {
            return false;
        }
        Integer this$price = this.getPrice();
        Integer other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Boolean this$needRecord = this.getNeedRecord();
        Boolean other$needRecord = other.getNeedRecord();
        if (this$needRecord == null ? other$needRecord != null : !((Object)this$needRecord).equals(other$needRecord)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Integer this$source = this.getSource();
        Integer other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Boolean this$isFree = this.getIsFree();
        Boolean other$isFree = other.getIsFree();
        if (this$isFree == null ? other$isFree != null : !((Object)this$isFree).equals(other$isFree)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Boolean this$isPublish = this.getIsPublish();
        Boolean other$isPublish = other.getIsPublish();
        if (this$isPublish == null ? other$isPublish != null : !((Object)this$isPublish).equals(other$isPublish)) {
            return false;
        }
        Integer this$courseType = this.getCourseType();
        Integer other$courseType = other.getCourseType();
        if (this$courseType == null ? other$courseType != null : !((Object)this$courseType).equals(other$courseType)) {
            return false;
        }
        Long this$liveRoomNum = this.getLiveRoomNum();
        Long other$liveRoomNum = other.getLiveRoomNum();
        if (this$liveRoomNum == null ? other$liveRoomNum != null : !((Object)this$liveRoomNum).equals(other$liveRoomNum)) {
            return false;
        }
        Long this$courseCategoryId = this.getCourseCategoryId();
        Long other$courseCategoryId = other.getCourseCategoryId();
        if (this$courseCategoryId == null ? other$courseCategoryId != null : !((Object)this$courseCategoryId).equals(other$courseCategoryId)) {
            return false;
        }
        Long this$columnId = this.getColumnId();
        Long other$columnId = other.getColumnId();
        if (this$columnId == null ? other$columnId != null : !((Object)this$columnId).equals(other$columnId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$columnImageUrl = this.getColumnImageUrl();
        String other$columnImageUrl = other.getColumnImageUrl();
        if (this$columnImageUrl == null ? other$columnImageUrl != null : !this$columnImageUrl.equals(other$columnImageUrl)) {
            return false;
        }
        String this$columnImageName = this.getColumnImageName();
        String other$columnImageName = other.getColumnImageName();
        if (this$columnImageName == null ? other$columnImageName != null : !this$columnImageName.equals(other$columnImageName)) {
            return false;
        }
        Long this$columnCode = this.getColumnCode();
        Long other$columnCode = other.getColumnCode();
        if (this$columnCode == null ? other$columnCode != null : !((Object)this$columnCode).equals(other$columnCode)) {
            return false;
        }
        Long this$inviteCode = this.getInviteCode();
        Long other$inviteCode = other.getInviteCode();
        if (this$inviteCode == null ? other$inviteCode != null : !((Object)this$inviteCode).equals(other$inviteCode)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$isSkipIntro = this.getIsSkipIntro();
        Boolean other$isSkipIntro = other.getIsSkipIntro();
        if (this$isSkipIntro == null ? other$isSkipIntro != null : !((Object)this$isSkipIntro).equals(other$isSkipIntro)) {
            return false;
        }
        Integer this$courseContentSource = this.getCourseContentSource();
        Integer other$courseContentSource = other.getCourseContentSource();
        if (this$courseContentSource == null ? other$courseContentSource != null : !((Object)this$courseContentSource).equals(other$courseContentSource)) {
            return false;
        }
        Boolean this$requireOnSale = this.getRequireOnSale();
        Boolean other$requireOnSale = other.getRequireOnSale();
        if (this$requireOnSale == null ? other$requireOnSale != null : !((Object)this$requireOnSale).equals(other$requireOnSale)) {
            return false;
        }
        Boolean this$isOnSale = this.getIsOnSale();
        Boolean other$isOnSale = other.getIsOnSale();
        if (this$isOnSale == null ? other$isOnSale != null : !((Object)this$isOnSale).equals(other$isOnSale)) {
            return false;
        }
        Boolean this$isStopUpdate = this.getIsStopUpdate();
        Boolean other$isStopUpdate = other.getIsStopUpdate();
        if (this$isStopUpdate == null ? other$isStopUpdate != null : !((Object)this$isStopUpdate).equals(other$isStopUpdate)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        Boolean this$isAuditionClass = this.getIsAuditionClass();
        Boolean other$isAuditionClass = other.getIsAuditionClass();
        if (this$isAuditionClass == null ? other$isAuditionClass != null : !((Object)this$isAuditionClass).equals(other$isAuditionClass)) {
            return false;
        }
        Boolean this$hasBeenCourse = this.getHasBeenCourse();
        Boolean other$hasBeenCourse = other.getHasBeenCourse();
        if (this$hasBeenCourse == null ? other$hasBeenCourse != null : !((Object)this$hasBeenCourse).equals(other$hasBeenCourse)) {
            return false;
        }
        Integer this$expectCount = this.getExpectCount();
        Integer other$expectCount = other.getExpectCount();
        if (this$expectCount == null ? other$expectCount != null : !((Object)this$expectCount).equals(other$expectCount)) {
            return false;
        }
        String this$SourceUrl = this.getSourceUrl();
        String other$SourceUrl = other.getSourceUrl();
        if (this$SourceUrl == null ? other$SourceUrl != null : !this$SourceUrl.equals(other$SourceUrl)) {
            return false;
        }
        Long this$tid = this.getTid();
        Long other$tid = other.getTid();
        if (this$tid == null ? other$tid != null : !((Object)this$tid).equals(other$tid)) {
            return false;
        }
        String this$audioUrl = this.getAudioUrl();
        String other$audioUrl = other.getAudioUrl();
        if (this$audioUrl == null ? other$audioUrl != null : !this$audioUrl.equals(other$audioUrl)) {
            return false;
        }
        String this$audioName = this.getAudioName();
        String other$audioName = other.getAudioName();
        if (this$audioName == null ? other$audioName != null : !this$audioName.equals(other$audioName)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$sourceCode = this.getSourceCode();
        String other$sourceCode = other.getSourceCode();
        if (this$sourceCode == null ? other$sourceCode != null : !this$sourceCode.equals(other$sourceCode)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$imageName = this.getImageName();
        String other$imageName = other.getImageName();
        if (this$imageName == null ? other$imageName != null : !this$imageName.equals(other$imageName)) {
            return false;
        }
        Integer this$taskId = this.getTaskId();
        Integer other$taskId = other.getTaskId();
        return !(this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CourseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        Long $courseCode = this.getCourseCode();
        result = result * 59 + ($courseCode == null ? 43 : ((Object)$courseCode).hashCode());
        String $chatroom = this.getChatroom();
        result = result * 59 + ($chatroom == null ? 43 : $chatroom.hashCode());
        Boolean $requireCourseCompleted = this.getRequireCourseCompleted();
        result = result * 59 + ($requireCourseCompleted == null ? 43 : ((Object)$requireCourseCompleted).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $courseImageUrl = this.getCourseImageUrl();
        result = result * 59 + ($courseImageUrl == null ? 43 : $courseImageUrl.hashCode());
        String $courseImageName = this.getCourseImageName();
        result = result * 59 + ($courseImageName == null ? 43 : $courseImageName.hashCode());
        String $teacherDisplayName = this.getTeacherDisplayName();
        result = result * 59 + ($teacherDisplayName == null ? 43 : $teacherDisplayName.hashCode());
        Object $intro = this.getIntro();
        result = result * 59 + ($intro == null ? 43 : $intro.hashCode());
        Date $beginTime = this.getBeginTime();
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        Integer $auditionMinutes = this.getAuditionMinutes();
        result = result * 59 + ($auditionMinutes == null ? 43 : ((Object)$auditionMinutes).hashCode());
        String $masterChatroom = this.getMasterChatroom();
        result = result * 59 + ($masterChatroom == null ? 43 : $masterChatroom.hashCode());
        List<String> $slaveChatroomList = this.getSlaveChatroomList();
        result = result * 59 + ($slaveChatroomList == null ? 43 : ((Object)$slaveChatroomList).hashCode());
        List<String> $teacherUsernameList = this.getTeacherUsernameList();
        result = result * 59 + ($teacherUsernameList == null ? 43 : ((Object)$teacherUsernameList).hashCode());
        Long $replayBaseLiveRoomNum = this.getReplayBaseLiveRoomNum();
        result = result * 59 + ($replayBaseLiveRoomNum == null ? 43 : ((Object)$replayBaseLiveRoomNum).hashCode());
        List<String> $tempLiveChatroomList = this.getTempLiveChatroomList();
        result = result * 59 + ($tempLiveChatroomList == null ? 43 : ((Object)$tempLiveChatroomList).hashCode());
        Integer $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Boolean $needRecord = this.getNeedRecord();
        result = result * 59 + ($needRecord == null ? 43 : ((Object)$needRecord).hashCode());
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Integer $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Boolean $isFree = this.getIsFree();
        result = result * 59 + ($isFree == null ? 43 : ((Object)$isFree).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Boolean $isPublish = this.getIsPublish();
        result = result * 59 + ($isPublish == null ? 43 : ((Object)$isPublish).hashCode());
        Integer $courseType = this.getCourseType();
        result = result * 59 + ($courseType == null ? 43 : ((Object)$courseType).hashCode());
        Long $liveRoomNum = this.getLiveRoomNum();
        result = result * 59 + ($liveRoomNum == null ? 43 : ((Object)$liveRoomNum).hashCode());
        Long $courseCategoryId = this.getCourseCategoryId();
        result = result * 59 + ($courseCategoryId == null ? 43 : ((Object)$courseCategoryId).hashCode());
        Long $columnId = this.getColumnId();
        result = result * 59 + ($columnId == null ? 43 : ((Object)$columnId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $columnImageUrl = this.getColumnImageUrl();
        result = result * 59 + ($columnImageUrl == null ? 43 : $columnImageUrl.hashCode());
        String $columnImageName = this.getColumnImageName();
        result = result * 59 + ($columnImageName == null ? 43 : $columnImageName.hashCode());
        Long $columnCode = this.getColumnCode();
        result = result * 59 + ($columnCode == null ? 43 : ((Object)$columnCode).hashCode());
        Long $inviteCode = this.getInviteCode();
        result = result * 59 + ($inviteCode == null ? 43 : ((Object)$inviteCode).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $isSkipIntro = this.getIsSkipIntro();
        result = result * 59 + ($isSkipIntro == null ? 43 : ((Object)$isSkipIntro).hashCode());
        Integer $courseContentSource = this.getCourseContentSource();
        result = result * 59 + ($courseContentSource == null ? 43 : ((Object)$courseContentSource).hashCode());
        Boolean $requireOnSale = this.getRequireOnSale();
        result = result * 59 + ($requireOnSale == null ? 43 : ((Object)$requireOnSale).hashCode());
        Boolean $isOnSale = this.getIsOnSale();
        result = result * 59 + ($isOnSale == null ? 43 : ((Object)$isOnSale).hashCode());
        Boolean $isStopUpdate = this.getIsStopUpdate();
        result = result * 59 + ($isStopUpdate == null ? 43 : ((Object)$isStopUpdate).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        Boolean $isAuditionClass = this.getIsAuditionClass();
        result = result * 59 + ($isAuditionClass == null ? 43 : ((Object)$isAuditionClass).hashCode());
        Boolean $hasBeenCourse = this.getHasBeenCourse();
        result = result * 59 + ($hasBeenCourse == null ? 43 : ((Object)$hasBeenCourse).hashCode());
        Integer $expectCount = this.getExpectCount();
        result = result * 59 + ($expectCount == null ? 43 : ((Object)$expectCount).hashCode());
        String $SourceUrl = this.getSourceUrl();
        result = result * 59 + ($SourceUrl == null ? 43 : $SourceUrl.hashCode());
        Long $tid = this.getTid();
        result = result * 59 + ($tid == null ? 43 : ((Object)$tid).hashCode());
        String $audioUrl = this.getAudioUrl();
        result = result * 59 + ($audioUrl == null ? 43 : $audioUrl.hashCode());
        String $audioName = this.getAudioName();
        result = result * 59 + ($audioName == null ? 43 : $audioName.hashCode());
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $sourceCode = this.getSourceCode();
        result = result * 59 + ($sourceCode == null ? 43 : $sourceCode.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $imageName = this.getImageName();
        result = result * 59 + ($imageName == null ? 43 : $imageName.hashCode());
        Integer $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        return result;
    }

    public String toString() {
        return "CourseRequest(pageDto=" + this.getPageDto() + ", courseCode=" + this.getCourseCode() + ", chatroom=" + this.getChatroom() + ", requireCourseCompleted=" + this.getRequireCourseCompleted() + ", topic=" + this.getTopic() + ", courseImageUrl=" + this.getCourseImageUrl() + ", courseImageName=" + this.getCourseImageName() + ", teacherDisplayName=" + this.getTeacherDisplayName() + ", intro=" + this.getIntro() + ", beginTime=" + this.getBeginTime() + ", auditionMinutes=" + this.getAuditionMinutes() + ", masterChatroom=" + this.getMasterChatroom() + ", slaveChatroomList=" + this.getSlaveChatroomList() + ", teacherUsernameList=" + this.getTeacherUsernameList() + ", replayBaseLiveRoomNum=" + this.getReplayBaseLiveRoomNum() + ", tempLiveChatroomList=" + this.getTempLiveChatroomList() + ", price=" + this.getPrice() + ", needRecord=" + this.getNeedRecord() + ", taskType=" + this.getTaskType() + ", source=" + this.getSource() + ", isFree=" + this.getIsFree() + ", password=" + this.getPassword() + ", isPublish=" + this.getIsPublish() + ", courseType=" + this.getCourseType() + ", liveRoomNum=" + this.getLiveRoomNum() + ", courseCategoryId=" + this.getCourseCategoryId() + ", columnId=" + this.getColumnId() + ", name=" + this.getName() + ", columnImageUrl=" + this.getColumnImageUrl() + ", columnImageName=" + this.getColumnImageName() + ", columnCode=" + this.getColumnCode() + ", inviteCode=" + this.getInviteCode() + ", status=" + this.getStatus() + ", isSkipIntro=" + this.getIsSkipIntro() + ", courseContentSource=" + this.getCourseContentSource() + ", requireOnSale=" + this.getRequireOnSale() + ", isOnSale=" + this.getIsOnSale() + ", isStopUpdate=" + this.getIsStopUpdate() + ", appId=" + this.getAppId() + ", isAuditionClass=" + this.getIsAuditionClass() + ", hasBeenCourse=" + this.getHasBeenCourse() + ", expectCount=" + this.getExpectCount() + ", SourceUrl=" + this.getSourceUrl() + ", tid=" + this.getTid() + ", audioUrl=" + this.getAudioUrl() + ", audioName=" + this.getAudioName() + ", duration=" + this.getDuration() + ", sourceCode=" + this.getSourceCode() + ", url=" + this.getUrl() + ", imageName=" + this.getImageName() + ", taskId=" + this.getTaskId() + ")";
    }
}

