/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.robotcenter.facade.enums;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class FileConstant {
    public static final String FIELD_CREATE_TIME = "create_time";
    public static final Set<String> ALL_FILED_SUPPORT_SORT = Collections.unmodifiableSet(new HashSet(){
        {
            this.add(FileConstant.FIELD_CREATE_TIME);
        }
    });
    public static final Set<String> ALL_IMAGE_EXTENSION_SET = Collections.unmodifiableSet(new HashSet(){
        {
            this.add("bmp");
            this.add("jpg");
            this.add("jpeg");
            this.add("tiff");
            this.add("gif");
            this.add("pcx");
            this.add("tga");
            this.add("exif");
            this.add("fpx");
            this.add("svg");
            this.add("psd");
            this.add("cdr");
            this.add("pcd");
            this.add("dxf");
            this.add("ufo");
            this.add("eps");
            this.add("ai");
            this.add("raw");
            this.add("WMF");
            this.add("png");
        }
    });
    public static final Set<String> ALL_DOC_EXTENSION_SET = Collections.unmodifiableSet(new HashSet(){
        {
            this.add("doc");
            this.add("xls");
            this.add("ppt");
            this.add("docx");
            this.add("xlsx");
            this.add("pptx");
            this.add("txt");
        }
    });
    public static final Set<String> ALL_VIDEO_EXTENSION_SET = Collections.unmodifiableSet(new HashSet(){
        {
            this.add("avi");
            this.add("rmvb");
            this.add("rm");
            this.add("asf");
            this.add("divx");
            this.add("mpg");
            this.add("mpeg");
            this.add("mpe");
            this.add("wmv");
            this.add("mp4");
            this.add("mkv");
            this.add("vob");
            this.add("flv");
            this.add("3gp");
        }
    });
    public static final Set<String> ALL_AUDIO_EXTENSION_SET = Collections.unmodifiableSet(new HashSet(){
        {
            this.add("mp3");
            this.add("ogg");
            this.add("wav");
            this.add("ape");
            this.add("cda");
            this.add("au");
            this.add("midi");
            this.add("mac");
            this.add("aac");
            this.add("a4c");
        }
    });
    public static final int DOC = 1;
    public static final int IMAGE = 2;
    public static final int AUDIO = 3;
    public static final int VIDEO = 4;
    public static final int OTHERS = 5;
    public static final Set<Integer> QUERY_FILE_EXTENSION_SET = Collections.unmodifiableSet(new HashSet(){
        {
            this.add(new Integer(1));
            this.add(new Integer(2));
            this.add(new Integer(3));
            this.add(new Integer(4));
            this.add(new Integer(5));
        }
    });

    public static int getExtType(String ext) {
        if (StringUtils.isBlank((String)ext)) {
            return 5;
        }
        if (ALL_DOC_EXTENSION_SET.contains(ext)) {
            return 1;
        }
        if (ALL_IMAGE_EXTENSION_SET.contains(ext)) {
            return 2;
        }
        if (ALL_AUDIO_EXTENSION_SET.contains(ext)) {
            return 3;
        }
        if (ALL_VIDEO_EXTENSION_SET.contains(ext)) {
            return 4;
        }
        return 5;
    }
}

