/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.orgclass.service.utils;

import com.baijia.orgclass.common.enums.BJCloudCodeEnums;
import com.baijia.orgclass.common.exception.BJCloudException;
import com.baijia.orgclass.common.utils.ConfigProperties;
import com.baijia.orgclass.common.utils.DateUtils;
import com.baijia.orgclass.common.utils.RestUtils;
import com.baijia.orgclass.common.utils.RestfulResult;
import com.google.common.collect.Lists;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaijiaYunUtil {
    private static final Logger log = LoggerFactory.getLogger(BaijiaYunUtil.class);
    private static final String PARTNER_ID = "baijia.live.partnerId";
    private static final String PARTNER_KEY = "baijia.live.partnerKey";
    private static final String BASE_URL = "baijia.live.baseUrl";
    private static final String SIGN_SPLIT = "&";

    public static String createSign(Map<String, String> params) {
        String sign = "";
        if (params == null || params.size() == 0) {
            return sign;
        }
        Map<String, String> sortParamMap = BaijiaYunUtil.sortMapByKey(params);
        String originStr = BaijiaYunUtil.createSignData(sortParamMap);
        log.info("[BaijiaYun] before md5 originStr str param:{}", (Object)originStr);
        sign = BaijiaYunUtil.MD5encode(originStr);
        log.info("[BaijiaYun] after md5 sign param:{}", (Object)sign);
        return sign;
    }

    public static Long createRoom(Map<String, String> params) throws BJCloudException, Exception {
        String controller = "openapi/room";
        String action = "create";
        Long roomId = null;
        RestfulResult restResult = RestUtils.rest((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)"http://test-api.baijiacloud.com", (String)controller, (String)action, null, params, null);
        int code = restResult.getCode();
        if (code != 0) {
            BJCloudCodeEnums enums = BJCloudCodeEnums.getBJCloudCodeEnums((int)code);
            if (enums != null) {
                throw new BJCloudException(enums);
            }
            throw new Exception();
        }
        if (restResult != null) {
            log.info("[BaijiaYun] get roomNo restResult:{}", (Object)restResult);
            roomId = Long.parseLong((String)((Map)restResult.getData()).get("room_id"));
        }
        return roomId;
    }

    public static void createEnterRoom(Map<String, String> params) {
        String controller = "web/room";
        String action = "enter";
        try {
            RestfulResult restResult = RestUtils.rest((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)ConfigProperties.getProperty((String)BASE_URL), (String)controller, (String)action, null, params, null);
            if (restResult != null) {
                log.info("[BaijiaYun] create enterRoom param:{}", (Object)restResult);
            }
        }
        catch (Exception e) {
            log.error("[BaijiaYun] \u83b7\u53d6\u76f4\u64ad\u623f\u95f4\u9519\u8bef error param:{}", (Throwable)e);
        }
    }

    private static Map<String, String> sortMapByKey(Map<String, String> map) {
        TreeMap<String, String> sortMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }

    private static String createSignData(Map<String, String> sortParamMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : sortParamMap.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(SIGN_SPLIT);
        }
        sb.append("partner_key").append("=").append(ConfigProperties.getProperty((String)PARTNER_KEY));
        return sb.toString();
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date startDate = new Date();
        Date endDate = DateUtils.getDateByDiffHour((Date)startDate, (int)25);
        map.put("title", "\u6d4b\u8bd5\u6559\u5ba4\u4f60\u597d\u5f04\u54c8\u7d27\u554a\u7a7a\u770b\u6765\u662f\u6478\u5230\u83abi\u4f60\u519c\u5b89\u83ab\u65f6\u95f4\u58a8\u8ff9\u554a\u4f60\u8bf4\u8bc4\u5ba1\u4f60\u8bf4\u5462\u54e6");
        map.put("type", String.valueOf(2));
        map.put("end_time", String.valueOf(endDate.getTime() / 1000L));
        map.put("start_time", String.valueOf(startDate.getTime() / 1000L));
        map.put("timestamp", String.valueOf(new Date().getTime() / 1000L));
        map.put("partner_id", ConfigProperties.getProperty((String)PARTNER_ID));
        String sign = BaijiaYunUtil.createSign(map);
        map.put("sign", sign);
        try {
            Long roomNo = BaijiaYunUtil.createRoom(map);
            System.out.println("############roomNo:" + roomNo);
        }
        catch (BJCloudException e) {
            log.info("error########" + e.getMessage() + "$$$$$$$" + e.getCodeMsg());
        }
        catch (Exception e) {
            System.out.println("############\u51fa\u9519\u4e86");
        }
    }

    public static String MD5encode(String pwd) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] bytes = digest.digest(pwd.getBytes());
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < bytes.length) {
                String s = Integer.toHexString(0xFF & bytes[i]);
                if (s.length() == 1) {
                    sb.append("0" + s);
                } else {
                    sb.append(s);
                }
                ++i;
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.info("[]");
            throw new RuntimeException("buhuifasheng");
        }
    }

    public static List<String> batchGetRoomIds(Map<String, String> param) throws BJCloudException, Exception {
        String controller = "openapi/room";
        String action = "/batchCreate";
        List dataList = Lists.newArrayList();
        RestfulResult restResult = RestUtils.rest((RestUtils.RestMethod)RestUtils.RestMethod.POST, (String)ConfigProperties.getProperty((String)BASE_URL), (String)controller, (String)action, null, param, null);
        int code = restResult.getCode();
        if (code != 0) {
            BJCloudCodeEnums enums = BJCloudCodeEnums.getBJCloudCodeEnums((int)code);
            if (enums != null) {
                log.error("[BaijiaYun] \u6279\u91cf\u83b7\u53d6\u76f4\u64ad\u623f\u95f4\u9519\u8bef error param:{}", (Object)enums);
                throw new BJCloudException(enums);
            }
            throw new Exception();
        }
        dataList = (List)restResult.getData();
        return dataList;
    }
}

